/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.slot.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullFunction;

public class CoinChestMenu
extends LazyMessageMenu {
    public final CoinChestBlockEntity be;
    private final List<CoinSlot> coinSlots;
    private final List<UpgradeInputSlot> upgradeSlots;
    private final List<SimpleSlot> inventorySlots;
    private Consumer<LazyPacketData> extraHandler = d -> {};

    public CoinChestMenu(int id, Inventory inventory, CoinChestBlockEntity be) {
        super((MenuType)ModMenus.COIN_CHEST.get(), id, inventory);
        this.be = be;
        this.be.startOpen(this.player);
        this.addValidator(BlockEntityValidator.of(be));
        this.addValidator((NonNullFunction<Player, Boolean>)((NonNullFunction)this.be::allowAccess));
        ArrayList<CoinSlot> cSlots = new ArrayList<CoinSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                CoinSlot s = new CoinSlot((Container)this.be.getStorage(), x + 9 * y, 8 + x * 18, 93 + y * 18, true);
                this.m_38897_(s);
                cSlots.add(s);
            }
        }
        this.coinSlots = ImmutableList.copyOf(cSlots);
        ArrayList<UpgradeInputSlot> uSlots = new ArrayList<UpgradeInputSlot>();
        for (int y = 0; y < 3; ++y) {
            int index = y;
            UpgradeInputSlot s = new UpgradeInputSlot((Container)this.be.getUpgrades(), y, 152, 21 + y * 18, this.be);
            s.setListener(() -> this.be.checkUpgradeEquipped(index));
            this.m_38897_(s);
            uSlots.add(s);
        }
        this.upgradeSlots = ImmutableList.copyOf(uSlots);
        ArrayList<SimpleSlot> iSlots = new ArrayList<SimpleSlot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                SimpleSlot s = new SimpleSlot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 161 + y * 18);
                iSlots.add(s);
                this.m_38897_(s);
            }
        }
        for (int x = 0; x < 9; ++x) {
            SimpleSlot s = new SimpleSlot((Container)inventory, x, 8 + x * 18, 219);
            iSlots.add(s);
            this.m_38897_(s);
        }
        this.inventorySlots = ImmutableList.copyOf(iSlots);
    }

    public void SetUpgradeSlotVisibility(boolean visible) {
        for (UpgradeInputSlot slot : this.upgradeSlots) {
            slot.active = visible;
        }
    }

    public void SetCoinSlotVisibility(boolean visible) {
        for (CoinSlot slot : this.coinSlots) {
            slot.active = visible;
        }
    }

    public void SetInventoryVisibility(boolean visible) {
        for (SimpleSlot slot : this.inventorySlots) {
            slot.active = visible;
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 30 ? !this.m_38903_(slotStack, 30, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, 30, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.be.stopOpen(player);
    }

    public final void AddExtraHandler(@Nonnull Consumer<LazyPacketData> extraHandler) {
        this.extraHandler = extraHandler;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        this.extraHandler.accept(message);
        for (CoinChestUpgradeData data : this.be.getChestUpgrades()) {
            data.upgrade.HandleMenuMessage(this, data, message);
        }
    }
}

