/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.CapabilityMoneyViewer;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.common.capability.MixedCapabilityProvider;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletMoneyViewer;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.enchantments.WalletEnchantment;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class WalletItem
extends Item {
    private static final SoundEvent emptyOpenSound = SoundEvents.f_11678_;
    private final ResourceLocation MODEL_TEXTURE;
    private final int level;
    private final int storageSize;

    public WalletItem(int level, int storageSize, String modelName, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.level = level;
        this.storageSize = storageSize;
        WalletMenuBase.updateMaxWalletSlots(this.storageSize);
        this.MODEL_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/entity/" + modelName + ".png");
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ICapabilityProvider temp;
        ArrayList<ICapabilityProvider> providers = new ArrayList<ICapabilityProvider>();
        providers.add(CapabilityMoneyViewer.createProvider(new WalletMoneyViewer(stack)));
        if (LightmansCurrency.isCuriosLoaded() && (temp = LCCurios.createWalletProvider(stack)) != null) {
            providers.add(temp);
        }
        return new MixedCapabilityProvider(providers);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 10;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    public static boolean validWalletStack(ItemStack walletStack) {
        if (walletStack.m_41619_()) {
            return true;
        }
        return WalletItem.isWallet(walletStack.m_41720_());
    }

    public static boolean isWallet(ItemStack item) {
        return !item.m_41619_() && WalletItem.isWallet(item.m_41720_());
    }

    public static boolean isWallet(Item item) {
        return item instanceof WalletItem;
    }

    public static boolean CanExchange(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletExchangeLevel.get();
    }

    public static boolean CanPickup(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletPickupLevel.get();
    }

    public static boolean HasBankAccess(WalletItem wallet) {
        if (wallet == null) {
            return false;
        }
        return wallet.level >= (Integer)LCConfig.SERVER.walletBankLevel.get();
    }

    public static int InventorySize(WalletItem wallet) {
        if (wallet == null) {
            return 0;
        }
        return wallet.storageSize;
    }

    public static int InventorySize(ItemStack wallet) {
        if (wallet.m_41720_() instanceof WalletItem) {
            return WalletItem.InventorySize((WalletItem)wallet.m_41720_());
        }
        return 0;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        if (WalletItem.CanPickup(this)) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.wallet.pickup", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        if (WalletItem.CanExchange(this)) {
            if (WalletItem.CanPickup(this)) {
                MutableComponent onOffText = WalletItem.getAutoExchange(stack) ? EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert.on", new Object[0]).m_130940_(ChatFormatting.GREEN) : EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert.off", new Object[0]).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.wallet.autoConvert", onOffText).m_130940_(ChatFormatting.YELLOW));
            } else {
                tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.wallet.manualConvert", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            }
        }
        if (WalletItem.HasBankAccess(this)) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.wallet.bankaccount", new Object[0]).m_130940_(ChatFormatting.YELLOW));
        }
        WalletEnchantment.addWalletEnchantmentTooltips(tooltip, stack);
        if (CoinAPI.API.NoDataAvailable()) {
            return;
        }
        IMoneyViewer handler = CapabilityMoneyViewer.getCapability(stack);
        if (handler != null) {
            MoneyView contents = handler.getStoredMoney();
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.wallet.storedmoney", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            for (MoneyValue val : contents.allValues()) {
                tooltip.add((Component)val.getText().m_130940_(ChatFormatting.DARK_GREEN));
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack wallet = player.m_21120_(hand);
        if (!world.f_46443_) {
            int walletSlot = WalletItem.GetWalletSlot(player.m_150109_(), wallet);
            if (walletSlot >= 0) {
                if (player.m_6047_() && !LightmansCurrency.isCuriosValid((LivingEntity)player)) {
                    boolean equippedWallet = false;
                    IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
                    if (walletHandler != null && walletHandler.getWallet().m_41619_()) {
                        walletHandler.setWallet(wallet);
                        player.m_21008_(hand, ItemStack.f_41583_);
                        new SPacketSyncWallet(player.m_19879_(), walletHandler.getWallet(), walletHandler.visible()).sendTo(player);
                        walletHandler.clean();
                        equippedWallet = true;
                    }
                    if (equippedWallet) {
                        walletSlot = -1;
                    }
                }
                WalletMenuBase.SafeOpenWalletMenu((ServerPlayer)player, walletSlot);
            } else {
                LightmansCurrency.LogError("Could not find the wallet in the players inventory!");
            }
        } else {
            player.f_19853_.m_5594_(player, player.m_20183_(), emptyOpenSound, SoundSource.PLAYERS, 0.75f, 1.25f + player.f_19853_.f_46441_.m_188501_() * 0.5f);
            if (!WalletItem.isEmpty(wallet)) {
                player.f_19853_.m_5594_(player, player.m_20183_(), (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
            }
        }
        return InteractionResultHolder.m_19090_((Object)wallet);
    }

    public static boolean isEmpty(@Nonnull ItemStack wallet) {
        return WalletItem.getWalletInventory(wallet).m_7983_();
    }

    private static int GetWalletSlot(Inventory inventory, ItemStack wallet) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != wallet) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack PickupCoin(ItemStack wallet, ItemStack coins) {
        SimpleContainer inventory = WalletItem.getWalletInventory(wallet);
        ItemStack returnValue = InventoryUtil.TryPutItemStack((Container)inventory, coins);
        if (WalletItem.getAutoExchange(wallet)) {
            CoinAPI.API.CoinExchangeAllUp((Container)inventory);
        }
        CoinAPI.API.SortCoinsByValue((Container)inventory);
        WalletItem.putWalletInventory(wallet, (Container)inventory);
        return returnValue;
    }

    public static void putWalletInventory(@Nonnull ItemStack wallet, @Nonnull Container inventory) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        InventoryUtil.saveAllItems("Items", wallet.m_41784_(), inventory);
    }

    @Nonnull
    public static SimpleContainer getWalletInventory(@Nonnull ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return new SimpleContainer(1);
        }
        CompoundTag compound = wallet.m_41784_();
        int inventorySize = WalletItem.InventorySize(wallet);
        if (!compound.m_128441_("Items")) {
            return new SimpleContainer(inventorySize);
        }
        return InventoryUtil.loadAllItems("Items", wallet.m_41784_(), inventorySize);
    }

    public static boolean getAutoExchange(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return false;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.m_41720_()) || !WalletItem.CanPickup((WalletItem)wallet.m_41720_())) {
            return false;
        }
        CompoundTag tag = wallet.m_41784_();
        if (!tag.m_128441_("AutoConvert")) {
            tag.m_128379_("AutoConvert", true);
            return true;
        }
        return tag.m_128471_("AutoConvert");
    }

    public static void toggleAutoExchange(ItemStack wallet) {
        if (!(wallet.m_41720_() instanceof WalletItem)) {
            return;
        }
        if (!WalletItem.CanExchange((WalletItem)wallet.m_41720_())) {
            return;
        }
        CompoundTag tag = wallet.m_41784_();
        boolean oldValue = WalletItem.getAutoExchange(wallet);
        tag.m_128379_("AutoConvert", !oldValue);
    }

    public static void QuickCollect(Player player, Container container, boolean allowSideChain) {
        ItemStack wallet = CoinAPI.API.getEquippedWallet(player);
        if (WalletItem.isWallet(wallet)) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!CoinAPI.API.IsCoin(stack, allowSideChain)) continue;
                stack = WalletItem.PickupCoin(wallet, stack);
                container.m_6836_(i, stack);
            }
        }
    }

    public ResourceLocation getModelTexture() {
        return this.MODEL_TEXTURE;
    }
}

