/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeItem;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class UpgradeItem
extends Item
implements IUpgradeItem {
    protected final UpgradeType upgradeType;
    private boolean addTooltips = true;
    Function<UpgradeData, List<Component>> customTooltips = null;

    public UpgradeItem(UpgradeType upgradeType, Item.Properties properties) {
        super(properties);
        this.upgradeType = upgradeType;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && player.m_6047_()) {
            CompoundTag tag = stack.m_41783_();
            boolean success = this.upgradeType.clearDataFromStack(tag);
            if (tag.m_128441_("UpgradeData")) {
                tag.m_128473_("UpgradeData");
                success = true;
            }
            if (success) {
                level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.35f + 0.9f, false);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public final boolean addsTooltips() {
        return this.addTooltips;
    }

    protected final void ignoreTooltips() {
        this.addTooltips = false;
    }

    protected final void setCustomTooltips(Function<UpgradeData, List<Component>> customTooltips) {
        this.customTooltips = customTooltips;
    }

    @Override
    @Nonnull
    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    @Override
    @Nonnull
    public UpgradeData getDefaultUpgradeData() {
        UpgradeData data = this.upgradeType.getDefaultData();
        this.fillUpgradeData(data);
        return data;
    }

    protected abstract void fillUpgradeData(UpgradeData var1);

    public static UpgradeData getUpgradeData(ItemStack stack) {
        if (stack.m_41720_() instanceof UpgradeItem) {
            CompoundTag tag;
            UpgradeData data = ((UpgradeItem)stack.m_41720_()).getDefaultUpgradeData();
            if (stack.m_41782_() && (tag = stack.m_41783_()).m_128425_("UpgradeData", 10)) {
                data.read(tag.m_128469_("UpgradeData"));
            }
            return data;
        }
        return UpgradeData.EMPTY;
    }

    public static void setUpgradeData(ItemStack stack, UpgradeData data) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            tag = stack.m_41784_();
            tag.m_128365_("UpgradeData", (Tag)data.writeToNBT(upgradeItem.upgradeType));
        } else {
            tag = stack.m_41784_();
            tag.m_128365_("UpgradeData", (Tag)data.writeToNBT());
        }
    }

    public static List<Component> getUpgradeTooltip(ItemStack stack) {
        try {
            return UpgradeItem.getUpgradeTooltip(stack, false);
        }
        catch (Throwable throwable) {
            return new ArrayList<Component>();
        }
    }

    public static List<Component> getUpgradeTooltip(ItemStack stack, boolean forceCollection) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem item2 = (UpgradeItem)item;
            if (!item2.addTooltips && !forceCollection) {
                return Lists.newArrayList();
            }
            UpgradeType type = item2.getUpgradeType();
            UpgradeData data = UpgradeItem.getUpgradeData(stack);
            if (item2.customTooltips != null) {
                return (List)item2.customTooltips.apply((Object)data);
            }
            return type.getTooltip(data);
        }
        return Lists.newArrayList();
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        List<Component> upgradeTooltips = UpgradeItem.getUpgradeTooltip(stack);
        if (upgradeTooltips != null) {
            tooltip.addAll(upgradeTooltips);
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public static class Simple
    extends UpgradeItem {
        public Simple(UpgradeType upgradeType, Item.Properties properties) {
            super(upgradeType, properties);
        }

        @Override
        protected void fillUpgradeData(UpgradeData data) {
        }
    }
}

