/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.tickets.TicketSaveData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TicketItem
extends Item {
    private final long creativeID;
    private final int creativeColor;

    public TicketItem(Item.Properties properties, long creativeID, Color creativeColor) {
        this(properties, creativeID, creativeColor.hexColor);
    }

    public TicketItem(Item.Properties properties, long creativeID, int creativeColor) {
        super(properties);
        this.creativeID = creativeID;
        this.creativeColor = creativeColor;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        long ticketID;
        if (TicketItem.isPass(stack)) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.ticket.pass", new Object[0]));
        }
        if ((ticketID = TicketItem.GetTicketID(stack)) >= -2L) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.ticket.id", ticketID));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        TicketItem.GetTicketID(stack);
    }

    public static boolean isTicket(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_TICKET);
    }

    public static boolean isPass(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_PASS);
    }

    public static boolean isTicketOrPass(ItemStack ticket) {
        return TicketItem.isTicket(ticket) || TicketItem.isPass(ticket);
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() instanceof TicketItem && InventoryUtil.ItemHasTag(ticket, LCTags.Items.TICKETS_MASTER);
    }

    public static long GetTicketID(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem) || !ticket.m_41782_()) {
            return Long.MIN_VALUE;
        }
        CompoundTag ticketTag = ticket.m_41783_();
        if (ticketTag.m_128425_("TicketID", 4)) {
            return ticketTag.m_128454_("TicketID");
        }
        if (ticketTag.m_128441_("TicketID")) {
            UUID oldID = ticketTag.m_128342_("TicketID");
            long newID = TicketSaveData.getConvertedID(oldID);
            ticketTag.m_128356_("TicketID", newID);
            ticketTag.m_128405_("TicketColor", Color.getFromIndex((long)newID).hexColor);
            return newID;
        }
        return Long.MIN_VALUE;
    }

    public static int GetTicketColor(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem) || !ticket.m_41782_()) {
            return 0xFFFFFF;
        }
        CompoundTag ticketTag = ticket.m_41783_();
        if (!ticketTag.m_128441_("TicketColor")) {
            return 0xFFFFFF;
        }
        return ticketTag.m_128451_("TicketColor");
    }

    public static int GetDefaultTicketColor(long ticketID) {
        if (ticketID == -1L) {
            return Color.YELLOW.hexColor;
        }
        if (ticketID == -2L) {
            return Color.BLUE.hexColor;
        }
        return Color.getFromIndex((long)ticketID).hexColor;
    }

    public static ItemStack CraftTicket(@Nonnull ItemStack master, @Nonnull Item item) {
        if (TicketItem.isMasterTicket(master)) {
            return TicketItem.CreateTicket(item, TicketItem.GetTicketID(master), TicketItem.GetTicketColor(master), 1);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack CreateTicket(Item item, long ticketID) {
        return TicketItem.CreateTicket(item, ticketID, TicketItem.GetDefaultTicketColor(ticketID));
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color) {
        return TicketItem.CreateTicket(item, ticketID, color, 1);
    }

    public static ItemStack CreateTicket(Item item, long ticketID, int color, int count) {
        ItemStack ticket = new ItemStack((ItemLike)item, count);
        CompoundTag tag = ticket.m_41784_();
        tag.m_128356_("TicketID", ticketID);
        tag.m_128405_("TicketColor", color);
        return ticket;
    }

    public static ItemStack CreateExampleTicket(@Nonnull Item item, @Nonnull Color color) {
        ItemStack ticket = new ItemStack((ItemLike)item);
        CompoundTag tag = ticket.m_41784_();
        tag.m_128405_("TicketColor", color.hexColor);
        return ticket;
    }

    public static void SetTicketColor(ItemStack ticket, Color color) {
        TicketItem.SetTicketColor(ticket, color.hexColor);
    }

    public static void SetTicketColor(ItemStack ticket, int color) {
        CompoundTag tag = ticket.m_41784_();
        tag.m_128405_("TicketColor", color);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_220152_(tab)) {
            list.add((Object)TicketItem.CreateTicket(this, this.creativeID, this.creativeColor));
        }
    }
}

