/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChocolateCoinItem
extends Item {
    private final List<MobEffectInstance> effects;
    private final float healing;

    public ChocolateCoinItem(MobEffectInstance ... effects) {
        this(0.0f, effects);
    }

    public ChocolateCoinItem(float healing, MobEffectInstance ... effects) {
        this(new Item.Properties(), healing, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, MobEffectInstance ... effects) {
        this(properties, 0.0f, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, float healing, MobEffectInstance ... effects) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(2).m_38758_(0.1f).m_38767_()));
        this.effects = ImmutableList.copyOf((Object[])effects);
        this.healing = healing;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (level == null) {
            return;
        }
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            if (this.healing > 0.0f) {
                tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.chocolate_coin.healing", (int)this.healing).m_130940_(ChatFormatting.BLUE));
            }
            if (this.effects.size() > 0) {
                ChocolateCoinItem.addPotionTooltip(this.effects, tooltip);
            }
        }
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entity) {
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            if (this.healing > 0.0f) {
                entity.m_5634_(this.healing);
            }
            for (MobEffectInstance effect : this.effects) {
                entity.m_7292_(new MobEffectInstance(effect));
            }
        }
        return super.m_5922_(stack, level, entity);
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> tooltip) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            return;
        }
        for (MobEffectInstance mobeffectinstance : list) {
            MutableComponent mutablecomponent = EasyText.translatable(mobeffectinstance.m_19576_(), new Object[0]);
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            Map map = mobeffect.m_19485_();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                    list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                }
            }
            if (mobeffectinstance.m_19564_() > 0) {
                mutablecomponent = EasyText.translatable("potion.withAmplifier", mutablecomponent, EasyText.translatable("potion.potency." + mobeffectinstance.m_19564_(), new Object[0]));
            }
            if (mobeffectinstance.m_19557_() > 20) {
                mutablecomponent = EasyText.translatable("potion.withDuration", mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)1.0f));
            }
            tooltip.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
        }
        if (!list1.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            tooltip.add((Component)EasyText.translatable("potion.whenDrank", new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((Component)EasyText.translatable("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1), EasyText.translatable(((Attribute)pair.getFirst()).m_22087_(), new Object[0])).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((Component)EasyText.translatable("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), ItemStack.f_41584_.format(d1 *= -1.0), EasyText.translatable(((Attribute)pair.getFirst()).m_22087_(), new Object[0])).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

