/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PlayerMoneyHolder
extends MoneyHolder {
    private final List<IPlayerMoneyHandler> handlers;

    public PlayerMoneyHolder(@Nonnull List<IPlayerMoneyHandler> handlers) {
        this.handlers = ImmutableList.copyOf(handlers);
    }

    @Nonnull
    public PlayerMoneyHolder updatePlayer(@Nonnull Player player) {
        for (IPlayerMoneyHandler handler : this.handlers) {
            handler.updatePlayer(player);
        }
        return this;
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        for (IPlayerMoneyHandler handler : this.handlers) {
            if (!handler.isMoneyTypeValid(insertAmount) || !(insertAmount = handler.insertMoney(insertAmount, simulation)).isEmpty()) continue;
            return MoneyValue.empty();
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        for (IPlayerMoneyHandler handler : this.handlers) {
            extractAmount = handler.extractMoney(extractAmount, simulation);
            if (!extractAmount.isEmpty()) continue;
            return MoneyValue.empty();
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return this.handlers.stream().anyMatch(h -> h.isMoneyTypeValid(value));
    }

    @Override
    protected boolean hasStoredMoneyChanged() {
        for (IPlayerMoneyHandler handler : this.handlers) {
            if (!handler.hasStoredMoneyChanged(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        for (IPlayerMoneyHandler handler : this.handlers) {
            handler.flagAsKnown(this);
            builder.merge(handler.getStoredMoney());
        }
    }

    @Override
    public Component getTooltipTitle() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.info.money.player", new Object[0]);
    }
}

