/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.gamerule;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModGameRules {
    private static final List<RuleData<?>> GAME_RULES = Lists.newArrayList();
    public static final GameRules.Key<GameRules.BooleanValue> KEEP_WALLET = ModGameRules.register("keepWallet", GameRules.Category.PLAYER, ModGameRules.createBoolean(false));
    public static final GameRules.Key<GameRules.IntegerValue> COIN_DROP_PERCENT = ModGameRules.register("coinDropPercent", GameRules.Category.PLAYER, ModGameRules.createInteger(0, ModGameRules.keepWithinLimits(0, 100)));

    private static GameRules.Type<GameRules.IntegerValue> createInteger(int defaultVal) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"m_46312_", (Class[])new Class[]{Integer.TYPE});
            m.setAccessible(true);
            return (GameRules.Type)m.invoke(null, defaultVal);
        }
        catch (Throwable e) {
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"create", (Class[])new Class[]{Integer.TYPE});
                m2.setAccessible(true);
                return (GameRules.Type)m2.invoke(null, defaultVal);
            }
            catch (Throwable e2) {
                LightmansCurrency.LogError("Create gamerule error", e);
                return null;
            }
        }
    }

    private static GameRules.Type<GameRules.IntegerValue> createInteger(int defaultVal, BiConsumer<MinecraftServer, GameRules.IntegerValue> callback) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"m_46294_", (Class[])new Class[]{Integer.TYPE, BiConsumer.class});
            m.setAccessible(true);
            return (GameRules.Type)m.invoke(null, defaultVal, callback);
        }
        catch (Throwable e) {
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"create", (Class[])new Class[]{Integer.TYPE, BiConsumer.class});
                m2.setAccessible(true);
                return (GameRules.Type)m2.invoke(null, defaultVal, callback);
            }
            catch (Throwable e2) {
                LightmansCurrency.LogError("Create gamerule error", e);
                return null;
            }
        }
    }

    private static GameRules.Type<GameRules.IntegerValue> searchForMethod(int defaultVal, BiConsumer<MinecraftServer, GameRules.IntegerValue> callback) {
        for (int i = 0; i < 100000; ++i) {
            try {
                String method = "m_" + NumberUtil.getAsStringOfLength(i, 5) + "_";
                Method m = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)method, (Class[])new Class[]{Integer.TYPE, BiConsumer.class});
                m.setAccessible(true);
                GameRules.Type value = (GameRules.Type)m.invoke(null, defaultVal, callback);
                if (value == null) continue;
                LightmansCurrency.LogDebug("Found Create Method: '" + method + "'!");
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean defaultVal) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"m_46250_", (Class[])new Class[]{Boolean.TYPE});
            m.setAccessible(true);
            return (GameRules.Type)m.invoke(null, defaultVal);
        }
        catch (Exception e) {
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"create", (Class[])new Class[]{Boolean.TYPE});
                m2.setAccessible(true);
                return (GameRules.Type)m2.invoke(null, defaultVal);
            }
            catch (Exception e2) {
                LightmansCurrency.LogError("Create gamerule error", e);
                return null;
            }
        }
    }

    private static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
        if (ruleType == null) {
            return null;
        }
        GameRules.Key ruleKey = new GameRules.Key(name, category);
        GAME_RULES.add(new RuleData<T>(name, category, ruleType));
        return ruleKey;
    }

    public static <T extends GameRules.Value<T>> T getCustomValue(@Nonnull Level level, @Nullable GameRules.Key<T> ruleKey) {
        if (ruleKey == null) {
            return null;
        }
        return (T)level.m_46469_().m_46170_(ruleKey);
    }

    public static boolean safeGetCustomBool(@Nonnull Level level, @Nullable GameRules.Key<GameRules.BooleanValue> ruleKey, boolean defaultValue) {
        GameRules.BooleanValue ruleVal = ModGameRules.getCustomValue(level, ruleKey);
        if (ruleVal == null) {
            return defaultValue;
        }
        return ruleVal.m_46223_();
    }

    public static int safeGetCustomInt(@Nonnull Level level, @Nullable GameRules.Key<GameRules.IntegerValue> ruleKey, int defaultValue) {
        GameRules.IntegerValue ruleVal = ModGameRules.getCustomValue(level, ruleKey);
        if (ruleVal == null) {
            return defaultValue;
        }
        return ruleVal.m_46288_();
    }

    public static void registerRules() {
        GAME_RULES.forEach(rule -> GameRules.m_46189_((String)rule.name, (GameRules.Category)rule.category, rule.ruleType));
        GAME_RULES.clear();
    }

    public static BiConsumer<MinecraftServer, GameRules.IntegerValue> keepWithinLimits(int lowerLimit, int upperLimit) {
        return (s, v) -> {
            int newValue;
            int oldValue = v.m_46288_();
            if (oldValue != (newValue = MathUtil.clamp(oldValue, lowerLimit, upperLimit))) {
                v.m_151489_(newValue, null);
            }
        };
    }

    private record RuleData<T extends GameRules.Value<T>>(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
    }
}

