/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.event_coins;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.events.ChainDataReloadedEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.data.ATMExchangeButtonData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.CoinInputType;
import io.github.lightman314.lightmanscurrency.api.money.coins.display.builtin.NumberDisplay;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.event_coins.EventRange;
import io.github.lightman314.lightmanscurrency.common.loot.modifier.ILootModifier;
import io.github.lightman314.lightmanscurrency.common.loot.modifier.SimpleLootModifier;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class ChocolateEventCoins {
    public static final String CHAIN = "chocolate_coins";
    public static final ILootModifier LOOT_MODIFIER = new ChocolateLootModifier();
    private static ChainData CHAIN_DATA = null;
    public static final EventRange CHRISTMAS = EventRange.create(12, 1, 12, 31);
    public static final EventRange VALENTINES = EventRange.create(2, 13, 2, 15);

    private ChocolateEventCoins() {
    }

    public static boolean shouldModifyLoot() {
        return (Boolean)LCConfig.COMMON.chocolateEventCoinLootDrops.get() != false && (CHRISTMAS.isActive() || VALENTINES.isActive());
    }

    public static ChainData getChainData() {
        if (CHAIN_DATA == null) {
            CHAIN_DATA = ChainData.builder(CHAIN, EasyText.translatable("lightmanscurrency.money.chain.chocolate_coins", new Object[0])).withCoreChain(ModItems.COIN_CHOCOLATE_COPPER).withCoin(ModItems.COIN_CHOCOLATE_IRON, 10).withCoin(ModItems.COIN_CHOCOLATE_GOLD, 10).withCoin(ModItems.COIN_CHOCOLATE_EMERALD, 10).withCoin(ModItems.COIN_CHOCOLATE_DIAMOND, 10).withCoin(ModItems.COIN_CHOCOLATE_NETHERITE, 10).back().atmBuilder().accept(ATMExchangeButtonData::generateChocolate).back().withDisplay(new NumberDisplay((Component)EasyText.translatable("lightmanscurrency.money.chain.chocolate_coins.display", new Object[0]), (Component)EasyText.translatable("lightmanscurrency.money.chain.chocolate_coins.display.wordy", new Object[0]), (Item)ModItems.COIN_CHOCOLATE_COPPER.get())).withInputType(CoinInputType.TEXT).asEvent().build();
        }
        return CHAIN_DATA;
    }

    @SubscribeEvent
    public static void registerChain(@Nonnull ChainDataReloadedEvent.Pre event) {
        if (((Boolean)LCConfig.COMMON.chocolateEventCoins.get()).booleanValue() && !event.chainExists(CHAIN)) {
            event.addEntry(ChocolateEventCoins.getChainData());
        }
    }

    private static class ChocolateLootModifier
    extends SimpleLootModifier {
        private ChocolateLootModifier() {
        }

        @Override
        protected boolean isEnabled() {
            return ChocolateEventCoins.shouldModifyLoot();
        }

        @Override
        protected double getSuccessChance() {
            return (Double)LCConfig.COMMON.chocolateCoinDropRate.get();
        }

        @Override
        public void replaceLoot(@Nonnull RandomSource random, @Nonnull List<ItemStack> loot) {
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem1.get(), (ItemLike)ModItems.COIN_CHOCOLATE_COPPER.get());
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem2.get(), (ItemLike)ModItems.COIN_CHOCOLATE_IRON.get());
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem3.get(), (ItemLike)ModItems.COIN_CHOCOLATE_GOLD.get());
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem4.get(), (ItemLike)ModItems.COIN_CHOCOLATE_EMERALD.get());
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem5.get(), (ItemLike)ModItems.COIN_CHOCOLATE_DIAMOND.get());
            this.replaceRandomItems(random, loot, (Item)LCConfig.COMMON.lootItem6.get(), (ItemLike)ModItems.COIN_CHOCOLATE_NETHERITE.get());
        }
    }
}

