/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class MoneyMendingEnchantment
extends Enchantment {
    public MoneyMendingEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, EnchantmentCategory.BREAKABLE, slots);
    }

    public int m_6183_(int level) {
        return level * 25;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6586_() {
        return 1;
    }

    protected boolean m_5975_(@Nonnull Enchantment otherEnchant) {
        return otherEnchant != Enchantments.f_44962_ && super.m_5975_(otherEnchant);
    }

    public static MoneyValue getRepairCost() {
        return (MoneyValue)LCConfig.SERVER.moneyMendingRepairCost.get();
    }

    public static void runEntityTick(@Nonnull LivingEntity entity, @Nonnull IMoneyHandler handler) {
        Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)((Enchantment)ModEnchantments.MONEY_MENDING.get()), (LivingEntity)entity, ItemStack::m_41768_);
        Object item = entry == null ? (LightmansCurrency.isCuriosValid(entity) ? LCCurios.getMoneyMendingItem(entity) : null) : (ItemStack)entry.getValue();
        if (item != null) {
            MoneyView availableFunds;
            MoneyValue repairCost = MoneyMendingEnchantment.getRepairCost();
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)item);
            if (enchantments.containsKey(Enchantments.f_44952_) && (Integer)enchantments.get(Enchantments.f_44952_) > 0) {
                repairCost = repairCost.addValue((MoneyValue)LCConfig.SERVER.moneyMendingInfinityCost.get());
            }
            if (!(availableFunds = handler.getStoredMoney()).containsValue(repairCost)) {
                return;
            }
            MoneyValue nextCost = repairCost;
            MoneyValue finalCost = MoneyValue.empty();
            int currentDamage = item.m_41773_();
            int repairAmount = 0;
            while (availableFunds.containsValue(nextCost) && repairAmount < currentDamage) {
                ++repairAmount;
                finalCost = nextCost;
                nextCost = nextCost.addValue(repairCost);
            }
            if (handler.extractMoney(finalCost, true).isEmpty()) {
                handler.extractMoney(finalCost, false);
                item.m_41721_(currentDamage - repairAmount);
            }
        }
    }
}

