/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ejection.OwnableBlockEjectedNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EjectionData
implements Container,
IClientTracker {
    private final OwnerData owner;
    MutableComponent traderName;
    List<ItemStack> items;
    private boolean isClient;

    public MutableComponent getTraderName() {
        return this.traderName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    private EjectionData() {
        this.owner = new OwnerData(this, o -> {});
        this.traderName = Component.m_237119_();
        this.items = new ArrayList<ItemStack>();
        this.isClient = false;
    }

    private EjectionData(OwnerData owner, MutableComponent traderName, List<ItemStack> items) {
        this.owner = new OwnerData(this, o -> {});
        this.traderName = Component.m_237119_();
        this.items = new ArrayList<ItemStack>();
        this.isClient = false;
        this.owner.copyFrom(owner);
        this.traderName = traderName;
        this.items = items;
    }

    public boolean canAccess(Player player) {
        if (LCAdminMode.isAdminPlayer(player)) {
            return true;
        }
        if (this.owner == null) {
            return false;
        }
        return this.owner.isMember(player);
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Owner", (Tag)this.owner.save());
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.traderName));
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Items", (Tag)itemList);
        return compound;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128441_("Owner")) {
            this.owner.load(compound.m_128469_("Owner"));
        }
        if (compound.m_128441_("Name")) {
            this.traderName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        }
        if (compound.m_128441_("Items")) {
            ListTag itemList = compound.m_128437_("Items", 10);
            this.items = new ArrayList<ItemStack>();
            for (int i = 0; i < itemList.size(); ++i) {
                this.items.add(ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i)));
            }
        }
    }

    public final void pushNotificationToOwner() {
        Team team = this.owner.getTeam();
        if (team != null) {
            for (PlayerReference admin : team.getAdminsAndOwner()) {
                NotificationAPI.PushPlayerNotification(admin.id, OwnableBlockEjectedNotification.create((Component)this.traderName));
            }
        } else {
            PlayerReference player = this.owner.getPlayer();
            if (player != null) {
                NotificationAPI.PushPlayerNotification(player.id, OwnableBlockEjectedNotification.create((Component)this.traderName));
            }
        }
    }

    public static EjectionData create(Level level, BlockPos pos, BlockState state, IDumpable trader) {
        return EjectionData.create(level, pos, state, trader, true);
    }

    public static EjectionData create(Level level, BlockPos pos, BlockState state, IDumpable trader, boolean dropBlock) {
        OwnerData owner = trader.getOwner();
        MutableComponent traderName = trader.getName();
        List<ItemStack> items = trader.getContents(level, pos, state, dropBlock);
        return new EjectionData(owner, traderName, items);
    }

    public static EjectionData loadData(CompoundTag compound) {
        EjectionData data = new EjectionData();
        data.load(compound);
        return data;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return this.items.get(slot).m_41620_(count);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.items.get(slot);
        this.items.set(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, @Nonnull ItemStack item) {
        if (slot >= this.items.size() || slot < 0) {
            return;
        }
        this.items.set(slot, item);
    }

    private void clearEmptySlots() {
        this.items.removeIf(ItemStack::m_41619_);
    }

    public void m_6596_() {
        if (this.isClient) {
            return;
        }
        this.clearEmptySlots();
        if (this.m_7983_()) {
            EjectionSaveData.RemoveEjectionData(this);
        } else {
            EjectionSaveData.MarkEjectionDataDirty();
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.canAccess(player);
    }
}

