/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class TicketRecipe
implements TicketStationRecipe {
    private final ResourceLocation id;
    private final Ingredient masterIngredient;
    private final Ingredient ingredient;
    private final Item ticketResult;

    public TicketRecipe(@Nonnull ResourceLocation id, @Nonnull Ingredient masterIngredient, @Nonnull Ingredient ingredient, @Nonnull Item result) {
        this.id = id;
        this.masterIngredient = masterIngredient;
        this.ingredient = ingredient;
        this.ticketResult = result;
    }

    @Override
    @Nonnull
    public List<ItemStack> jeiModifierList() {
        return TicketStationRecipe.exampleTicketList(this.masterIngredient);
    }

    @Override
    @Nonnull
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @Nonnull
    public ItemStack exampleResult() {
        return new ItemStack((ItemLike)this.ticketResult);
    }

    @Override
    public boolean consumeModifier() {
        return false;
    }

    @Override
    public boolean validModifier(@Nonnull ItemStack stack) {
        return this.masterIngredient.test(stack);
    }

    @Override
    public boolean validIngredient(@Nonnull ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container container) {
        return TicketItem.CraftTicket(container.m_8020_(0), this.ticketResult);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_() {
        if (this.masterIngredient.m_43908_().length == 0) {
            return ItemStack.f_41583_;
        }
        return TicketItem.CraftTicket(TicketItem.CreateTicket(this.masterIngredient.m_43908_()[0].m_41720_(), -1L), this.ticketResult);
    }

    @Override
    @Nonnull
    public ItemStack peekAtResult(@Nonnull Container container) {
        return TicketItem.CraftTicket(container.m_8020_(0), this.ticketResult);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.TICKET.get();
    }

    public static class Serializer
    implements RecipeSerializer<TicketRecipe> {
        @Nonnull
        public TicketRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            Ingredient masterIngredient = Ingredient.m_43917_((JsonElement)json.get("masterTicket"));
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            Item item = CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"result"), (boolean)true);
            return new TicketRecipe(id, masterIngredient, ingredient, item);
        }

        @Nullable
        public TicketRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            return new TicketRecipe(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_().m_41720_());
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull TicketRecipe recipe) {
            recipe.masterIngredient.m_43923_(buffer);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(new ItemStack((ItemLike)recipe.ticketResult));
        }
    }
}

