/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.ModCreativeGroups;
import io.github.lightman314.lightmanscurrency.common.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinChestBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TaxCollectorBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TicketStationBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.tradeinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.BookTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.NetworkItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.reference.AuctionStandBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import io.github.lightman314.lightmanscurrency.common.items.CustomBlockModelItem;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    private static final SoundType CHOCOLATE_SOUND = SoundType.f_222470_;
    public static final RegistryObject<Block> COINPILE_COPPER;
    public static final RegistryObject<Block> COINPILE_IRON;
    public static final RegistryObject<Block> COINPILE_GOLD;
    public static final RegistryObject<Block> COINPILE_DIAMOND;
    public static final RegistryObject<Block> COINPILE_EMERALD;
    public static final RegistryObject<Block> COINPILE_NETHERITE;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_COPPER;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_IRON;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_GOLD;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_DIAMOND;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_EMERALD;
    public static final RegistryObject<Block> COINPILE_CHOCOLATE_NETHERITE;
    public static final RegistryObject<Block> COINBLOCK_COPPER;
    public static final RegistryObject<Block> COINBLOCK_IRON;
    public static final RegistryObject<Block> COINBLOCK_GOLD;
    public static final RegistryObject<Block> COINBLOCK_EMERALD;
    public static final RegistryObject<Block> COINBLOCK_DIAMOND;
    public static final RegistryObject<Block> COINBLOCK_NETHERITE;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_COPPER;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_IRON;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_GOLD;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_EMERALD;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_DIAMOND;
    public static final RegistryObject<Block> COINBLOCK_CHOCOLATE_NETHERITE;
    public static final RegistryObject<Block> ATM;
    public static final RegistryObject<Block> COIN_MINT;
    public static final RegistryObject<Block> DISPLAY_CASE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE;
    public static final RegistryObjectBundle<Block, Color> VENDING_MACHINE_LARGE;
    public static final RegistryObjectBundle<Block, WoodType> SHELF;
    public static final RegistryObjectBundle<Block, WoodType> SHELF_2x2;
    public static final RegistryObjectBiBundle<Block, WoodType, Color> CARD_DISPLAY;
    public static final RegistryObject<Block> ARMOR_DISPLAY;
    public static final RegistryObjectBundle<FreezerBlock, Color> FREEZER;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_1;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_2;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_3;
    public static final RegistryObject<Block> ITEM_NETWORK_TRADER_4;
    public static final RegistryObject<Block> ITEM_TRADER_INTERFACE;
    public static final RegistryObject<Block> CASH_REGISTER;
    public static final RegistryObject<Block> TERMINAL;
    public static final RegistryObject<Block> GEM_TERMINAL;
    public static final RegistryObject<Block> PAYGATE;
    public static final RegistryObject<Block> TICKET_KIOSK;
    public static final RegistryObjectBundle<Block, WoodType> BOOKSHELF_TRADER;
    public static final RegistryObject<Block> SLOT_MACHINE;
    public static final RegistryObject<Block> TICKET_STATION;
    public static final RegistryObject<Block> COIN_CHEST;
    public static final RegistryObject<TaxCollectorBlock> TAX_COLLECTOR;
    public static final RegistryObject<Block> PIGGY_BANK;
    public static final RegistryObject<Block> COINJAR_BLUE;
    public static final RegistryObject<Block> SUS_JAR;
    public static final RegistryObjectBundle<Block, WoodType> AUCTION_STAND;

    public static void init() {
    }

    private static Item.Properties PropertiesForTab(CreativeModeTab tab) {
        Item.Properties properties = new Item.Properties();
        if (tab != null) {
            properties.m_41491_(tab);
        }
        return properties;
    }

    private static Item.Properties FireResistant(Item.Properties properties, boolean fireResistant) {
        if (fireResistant) {
            return properties.m_41486_();
        }
        return properties;
    }

    private static BiFunction<Block, CreativeModeTab, Item> getDefaultGenerator() {
        return (block, tab) -> new BlockItem(block, ModBlocks.PropertiesForTab(tab));
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinGenerator(boolean fireResistant) {
        return (block, tab) -> new BlockItem(block, ModBlocks.FireResistant(ModBlocks.PropertiesForTab(tab), fireResistant));
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinJarGenerator() {
        return (block, tab) -> new CoinJarItem((Block)block, ModBlocks.PropertiesForTab(tab));
    }

    private static BiFunction<Block, CreativeModeTab, Item> getColoredCoinJarGenerator() {
        return (block, tab) -> new CoinJarItem.Colored((Block)block, ModBlocks.PropertiesForTab(tab));
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCustomRendererGenerator() {
        return (block, tab) -> new CustomBlockModelItem((Block)block, ModBlocks.PropertiesForTab(tab));
    }

    private static <T extends Block> RegistryObject<T> register(String name, NonNullSupplier<CreativeModeTab> itemGroup, com.google.common.base.Supplier<T> sup) {
        return ModBlocks.register(name, itemGroup, ModBlocks.getDefaultGenerator(), sup);
    }

    private static <T extends Block> RegistryObject<T> register(String name, NonNullSupplier<CreativeModeTab> itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, com.google.common.base.Supplier<T> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get(), itemGroup != null ? (CreativeModeTab)itemGroup.get() : null));
        }
        return block;
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, NonNullSupplier<CreativeModeTab> itemGroup, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        return ModBlocks.registerColored(name, itemGroup, ModBlocks.getDefaultGenerator(), block, dontNameThisColor);
    }

    private static <T extends Block> RegistryObjectBundle<T, Color> registerColored(String name, NonNullSupplier<CreativeModeTab> itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Function<Color, T> block, @Nullable Color dontNameThisColor) {
        RegistryObjectBundle<T, Color> bundle = new RegistryObjectBundle<T, Color>(Color::sortByColor);
        for (Color color : Color.values()) {
            Object thisName = name;
            if (color != dontNameThisColor) {
                thisName = (String)thisName + "_" + color.getResourceSafeName();
            }
            bundle.put(color, ModBlocks.register((String)thisName, itemGroup, itemGenerator, () -> (Block)block.apply(color)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, NonNullFunction<WoodType, CreativeModeTab> itemGroup, Function<WoodType, T> block) {
        return ModBlocks.registerWooden(name, check, itemGroup, ModBlocks.getDefaultGenerator(), block);
    }

    private static <T extends Block> RegistryObjectBundle<T, WoodType> registerWooden(String name, Predicate<WoodType.Attributes> check, NonNullFunction<WoodType, CreativeModeTab> itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Function<WoodType, T> block) {
        RegistryObjectBundle<T, WoodType> bundle = new RegistryObjectBundle<T, WoodType>(WoodType::sortByWood);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            String thisName = woodType.generateID(name);
            bundle.put(woodType, ModBlocks.register(thisName, (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)() -> (CreativeModeTab)itemGroup.apply((Object)woodType)), itemGenerator, () -> (Block)block.apply(woodType)));
        }
        return bundle.lock();
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, NonNullFunction<WoodType, CreativeModeTab> itemGroup, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, itemGroup, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, NonNullFunction<WoodType, CreativeModeTab> itemGroup, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        return ModBlocks.registerWoodenAndColored(name, check, ModBlocks.getDefaultGenerator(), itemGroup, block, ignoreColor);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<Block, CreativeModeTab, Item> itemGenerator, NonNullFunction<WoodType, CreativeModeTab> itemGroup, BiFunction<WoodType, Color, T> block) {
        return ModBlocks.registerWoodenAndColored(name, check, itemGenerator, itemGroup, block, null);
    }

    private static <T extends Block> RegistryObjectBiBundle<T, WoodType, Color> registerWoodenAndColored(String name, Predicate<WoodType.Attributes> check, BiFunction<Block, CreativeModeTab, Item> itemGenerator, NonNullFunction<WoodType, CreativeModeTab> itemGroup, BiFunction<WoodType, Color, T> block, @Nullable Color ignoreColor) {
        RegistryObjectBiBundle<T, WoodType, Color> bundle = new RegistryObjectBiBundle<T, WoodType, Color>(WoodType::sortByWood, Color::sortByColor);
        for (WoodType woodType : WoodType.validValues()) {
            if (!check.test(woodType.attributes)) continue;
            for (Color color : Color.values()) {
                Object thisName = color == ignoreColor ? woodType.generateID(name) : woodType.generateID(name) + "_" + color.getResourceSafeName();
                bundle.put(woodType, color, ModBlocks.register((String)thisName, (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)() -> (CreativeModeTab)itemGroup.apply((Object)woodType)), itemGenerator, () -> (Block)block.apply(woodType, color)));
            }
        }
        return bundle.lock();
    }

    public static RegistryObjectBundle<FreezerBlock, Color> registerFreezer(String name, NonNullSupplier<CreativeModeTab> itemGroup, Function<Color, FreezerBlock> block) {
        return ModBlocks.registerFreezer(name, itemGroup, ModBlocks.getDefaultGenerator(), block);
    }

    public static RegistryObjectBundle<FreezerBlock, Color> registerFreezer(String name, NonNullSupplier<CreativeModeTab> itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Function<Color, FreezerBlock> block) {
        RegistryObjectBundle bundle = new RegistryObjectBundle(Color::sortByColor);
        for (Color color : Color.values()) {
            String thisName = color == Color.BLACK ? name : name + "_" + color.getResourceSafeName();
            bundle.put(color, ModBlocks.register(thisName, itemGroup, itemGenerator, () -> (FreezerBlock)block.apply(color)));
        }
        return bundle.lock();
    }

    static {
        LightmansCurrency.LogDebug("Loading the ModBlocks class!");
        COINPILE_COPPER = ModBlocks.register("coinpile_copper", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76413_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_COPPER));
        COINPILE_IRON = ModBlocks.register("coinpile_iron", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_IRON));
        COINPILE_GOLD = ModBlocks.register("coinpile_gold", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_GOLD));
        COINPILE_EMERALD = ModBlocks.register("coinpile_emerald", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76369_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_EMERALD));
        COINPILE_DIAMOND = ModBlocks.register("coinpile_diamond", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76367_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_DIAMOND));
        COINPILE_NETHERITE = ModBlocks.register("coinpile_netherite", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76365_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_NETHERITE));
        COINPILE_CHOCOLATE_COPPER = ModBlocks.register("coinpile_chocolate_copper", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_155949_(MaterialColor.f_76413_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_COPPER));
        COINPILE_CHOCOLATE_IRON = ModBlocks.register("coinpile_chocolate_iron", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_IRON));
        COINPILE_CHOCOLATE_GOLD = ModBlocks.register("coinpile_chocolate_gold", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_GOLD));
        COINPILE_CHOCOLATE_EMERALD = ModBlocks.register("coinpile_chocolate_emerald", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76369_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_EMERALD));
        COINPILE_CHOCOLATE_DIAMOND = ModBlocks.register("coinpile_chocolate_diamond", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76367_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_DIAMOND));
        COINPILE_CHOCOLATE_NETHERITE = ModBlocks.register("coinpile_chocolate_netherite", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(true), () -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76365_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_NETHERITE));
        COINBLOCK_COPPER = ModBlocks.register("coinblock_copper", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76413_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_COPPER));
        COINBLOCK_IRON = ModBlocks.register("coinblock_iron", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_IRON));
        COINBLOCK_GOLD = ModBlocks.register("coinblock_gold", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_GOLD));
        COINBLOCK_EMERALD = ModBlocks.register("coinblock_emerald", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76369_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_EMERALD));
        COINBLOCK_DIAMOND = ModBlocks.register("coinblock_diamond", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76367_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_DIAMOND));
        COINBLOCK_NETHERITE = ModBlocks.register("coinblock_netherite", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76365_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), (Supplier<Item>)ModItems.COIN_NETHERITE));
        COINBLOCK_CHOCOLATE_COPPER = ModBlocks.register("coinblock_chocolate_copper", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76413_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_COPPER));
        COINBLOCK_CHOCOLATE_IRON = ModBlocks.register("coinblock_chocolate_iron", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_IRON));
        COINBLOCK_CHOCOLATE_GOLD = ModBlocks.register("coinblock_chocolate_gold", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_GOLD));
        COINBLOCK_CHOCOLATE_EMERALD = ModBlocks.register("coinblock_chocolate_emerald", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76369_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_EMERALD));
        COINBLOCK_CHOCOLATE_DIAMOND = ModBlocks.register("coinblock_chocolate_diamond", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(false), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76367_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_DIAMOND));
        COINBLOCK_CHOCOLATE_NETHERITE = ModBlocks.register("coinblock_chocolate_netherite", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getCoinGroup), ModBlocks.getCoinGenerator(true), () -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76365_).m_60913_(3.0f, 6.0f).m_60918_(CHOCOLATE_SOUND), (Supplier<Item>)ModItems.COIN_CHOCOLATE_NETHERITE));
        ATM = ModBlocks.register("atm", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new ATMBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76419_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COIN_MINT = ModBlocks.register("coinmint", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new CoinMintBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76415_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        CASH_REGISTER = ModBlocks.register("cash_register", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new CashRegisterItem((Block)block, properties);
        }, () -> new CashRegisterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76419_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)));
        DISPLAY_CASE = ModBlocks.register("display_case", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new DisplayCaseBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_)));
        VENDING_MACHINE = ModBlocks.registerColored("vending_machine", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), c -> new VendingMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)), Color.WHITE);
        VENDING_MACHINE_LARGE = ModBlocks.registerColored("vending_machine_large", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), c -> new VendingMachineLargeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)), Color.WHITE);
        SHELF = ModBlocks.registerWooden("shelf", WoodType.Attributes.needsSlab, ModCreativeGroups.getExtraOr((NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup)), w -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_)));
        SHELF_2x2 = ModBlocks.registerWooden("shelf_2x2", WoodType.Attributes.needsSlab, ModCreativeGroups.getExtraOr((NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup)), w -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_), 4));
        CARD_DISPLAY = ModBlocks.registerWoodenAndColored("card_display", WoodType.Attributes.needsLog, ModCreativeGroups.getExtraOr((NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup)), (WoodType w, Color c) -> new CardDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(w.mapColor).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_), w.generateID("block.lightmanscurrency.card_display"), (Color)((Object)c)), Color.RED);
        FREEZER = ModBlocks.registerColored("freezer", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), c -> new FreezerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(c.mapColor).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), FreezerBlock.GenerateDoorModel(c)), Color.BLACK);
        ARMOR_DISPLAY = ModBlocks.register("armor_display", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new ArmorDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TICKET_KIOSK = ModBlocks.register("ticket_kiosk", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new TicketKioskBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        BOOKSHELF_TRADER = ModBlocks.registerWooden("bookshelf_trader", WoodType.Attributes.needsPlanksAndSlab, ModCreativeGroups.getExtraOr((NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup)), w -> new BookTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(w.mapColor).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_)));
        SLOT_MACHINE = ModBlocks.register("slot_machine", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new SlotMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76416_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        ITEM_NETWORK_TRADER_1 = ModBlocks.register("item_trader_server_sml", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 4));
        ITEM_NETWORK_TRADER_2 = ModBlocks.register("item_trader_server_med", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 8));
        ITEM_NETWORK_TRADER_3 = ModBlocks.register("item_trader_server_lrg", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 12));
        ITEM_NETWORK_TRADER_4 = ModBlocks.register("item_trader_server_xlrg", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new NetworkItemTraderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 16));
        ITEM_TRADER_INTERFACE = ModBlocks.register("item_trader_interface", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new ItemTraderInterfaceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TERMINAL = ModBlocks.register("terminal", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)));
        GEM_TERMINAL = ModBlocks.register("gem_terminal", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_155949_(MaterialColor.f_76422_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_154655_), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)));
        PAYGATE = ModBlocks.register("paygate", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getTradingGroup), () -> new PaygateBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        TICKET_STATION = ModBlocks.register("ticket_machine", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new TicketStationBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        COIN_CHEST = ModBlocks.register("coin_chest", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), ModBlocks.getCustomRendererGenerator(), () -> new CoinChestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(MaterialColor.f_76411_).m_60913_(2.5f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_)));
        TAX_COLLECTOR = ModBlocks.register("tax_block", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), () -> new TaxCollectorBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_155949_(MaterialColor.f_76366_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_)));
        PIGGY_BANK = ModBlocks.register("piggy_bank", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_76418_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        COINJAR_BLUE = ModBlocks.register("coinjar_blue", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), ModBlocks.getCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_76361_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        SUS_JAR = ModBlocks.register("sus_jar", (NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup), ModBlocks.getColoredCoinJarGenerator(), () -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_76406_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)));
        AUCTION_STAND = ModBlocks.registerWooden("auction_stand", WoodType.Attributes.needsLog, ModCreativeGroups.getExtraOr((NonNullSupplier<CreativeModeTab>)((NonNullSupplier)ModCreativeGroups::getMachineGroup)), w -> new AuctionStandBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_155949_(w.mapColor).m_60978_(2.0f)));
    }
}

