/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TradeIDArgument;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTrade;
import io.github.lightman314.lightmanscurrency.common.playertrading.PlayerTradeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandPlayerTrading {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder requestTradeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lctrade").requires(CommandSourceStack::m_230897_)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(CommandPlayerTrading::requestPlayerTrade));
        LiteralArgumentBuilder acceptTradeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lctradeaccept").requires(CommandSourceStack::m_230897_)).then(Commands.m_82129_((String)"tradeID", (ArgumentType)TradeIDArgument.argument()).executes(CommandPlayerTrading::acceptPlayerTrade));
        dispatcher.register(requestTradeCommand);
        dispatcher.register(acceptTradeCommand);
    }

    private static int requestPlayerTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer host = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerPlayer guest = EntityArgument.m_91474_(context, (String)"player");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (guest == host) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lctrade.self", new Object[0]));
            return 0;
        }
        int tradeID = PlayerTradeManager.CreateNewTrade(host, guest);
        host.m_213846_((Component)EasyText.translatable("command.lightmanscurrency.lctrade.host.notify", guest.m_7755_()));
        guest.m_213846_((Component)EasyText.translatable("command.lightmanscurrency.lctrade.guest.notify", host.m_7755_(), EasyText.translatable("command.lightmanscurrency.lctrade.guest.notify.here", new Object[0]).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GREEN).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lctradeaccept " + tradeID)))).m_130940_(ChatFormatting.GOLD));
        return 1;
    }

    private static int acceptPlayerTrade(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer guest = ((CommandSourceStack)context.getSource()).m_81375_();
        int tradeID = TradeIDArgument.getTradeID(context, "tradeID");
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        PlayerTrade trade = PlayerTradeManager.GetTrade(tradeID);
        if (trade != null && trade.isGuest((Player)guest)) {
            int rangeResult = trade.isGuestInRange(guest);
            if (rangeResult > 0) {
                EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lctradeaccept.fail." + rangeResult, PlayerTrade.enforceDistance()));
                return 0;
            }
            if (trade.requestAccepted(guest)) {
                return 1;
            }
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lctradeaccept.error", new Object[0]));
            return 0;
        }
        EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lctradeaccept.notfound", new Object[0]));
        return 0;
    }
}

