/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.CapabilityEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.event_unlocks.IEventUnlocks;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.TraderArgument;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandLCAdmin {
    private static final SimpleCommandExceptionType ERROR_BLOCK_NOT_FOUND = new SimpleCommandExceptionType((Message)EasyText.translatable("command.trader.block.notfound", new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcadmin").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"toggleadmin").requires(CommandSourceStack::m_230897_)).executes(CommandLCAdmin::toggleAdmin))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"traderdata").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listTraderData))).then(Commands.m_82127_((String)"search").then(Commands.m_82129_((String)"searchText", (ArgumentType)StringArgumentType.greedyString()).executes(CommandLCAdmin::searchTraderData)))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::deleteTraderData)))).then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.trader()).executes(CommandLCAdmin::debugTraderData)))).then(Commands.m_82127_((String)"addToWhitelist").then(Commands.m_82129_((String)"traderID", (ArgumentType)TraderArgument.traderWithPersistent()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(CommandLCAdmin::addToTraderWhitelist)))))).then(Commands.m_82127_((String)"prepareForStructure").then(Commands.m_82129_((String)"traderPos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CommandLCAdmin::setCustomTrader)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"replaceWallet").requires(c -> !LightmansCurrency.isCuriosLoaded())).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"wallet", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(CommandLCAdmin::replaceWalletSlotWithDefault)).then(Commands.m_82129_((String)"keepWalletContents", (ArgumentType)BoolArgumentType.bool()).executes(CommandLCAdmin::replaceWalletSlot)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"taxes").then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listTaxCollectors))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"taxCollectorID", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(CommandLCAdmin::deleteTaxCollector)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"openServerTax").requires(CommandSourceStack::m_230897_)).executes(CommandLCAdmin::openServerTax))).then(Commands.m_82127_((String)"forceDisableTaxCollectors").executes(CommandLCAdmin::forceDisableTaxCollectors)))).then(Commands.m_82127_((String)"events").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"reward").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CommandLCAdmin::giveEventReward))))).then(Commands.m_82127_((String)"list").executes(CommandLCAdmin::listUnlockedEvents))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::unlockEvent)))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).executes(CommandLCAdmin::lockEvent)))));
        dispatcher.register(lcAdminCommand);
    }

    static int toggleAdmin(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer sourcePlayer = source.m_81375_();
        LCAdminMode.ToggleAdminPlayer(sourcePlayer);
        MutableComponent enabledDisabled = LCAdminMode.isAdminPlayer((Player)sourcePlayer) ? EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin.enabled", new Object[0]).m_130940_(ChatFormatting.GREEN) : EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin.disabled", new Object[0]).m_130940_(ChatFormatting.RED);
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.toggleadmin", enabledDisabled), true);
        return 1;
    }

    static int setCustomTrader(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        BlockPos pos = BlockPosArgument.m_118242_(commandContext, (String)"traderPos");
        ServerLevel level = source.m_81372_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = state.m_60734_() instanceof ITraderBlock ? ((ITraderBlock)state.m_60734_()).getBlockEntity(state, (LevelAccessor)level, pos) : level.m_7702_(pos);
        if (be instanceof TraderBlockEntity) {
            TraderBlockEntity t = (TraderBlockEntity)be;
            t.saveCurrentTraderAsCustomTrader();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.setCustomTrader.success", new Object[0]), true);
            return 1;
        }
        throw ERROR_BLOCK_NOT_FOUND.create();
    }

    static int listTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
        if (!allTraders.isEmpty()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.title", new Object[0]), true);
            for (int i = 0; i < allTraders.size(); ++i) {
                TraderData thisTrader = allTraders.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.none", new Object[0]), true);
        }
        return 1;
    }

    static int searchTraderData(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        String searchText = StringArgumentType.getString(commandContext, (String)"searchText");
        List<TraderData> results = TraderSaveData.GetAllTraders(false).stream().filter(trader -> TraderAPI.filterTrader(trader, searchText)).toList();
        if (!results.isEmpty()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.title", new Object[0]), true);
            for (int i = 0; i < results.size(); ++i) {
                TraderData thisTrader = results.get(i);
                if (i > 0) {
                    EasyText.sendCommandSucess(source, (Component)EasyText.empty(), true);
                }
                CommandLCAdmin.sendTraderDataFeedback(thisTrader, source);
            }
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.search.none", new Object[0]), true);
        }
        return 1;
    }

    private static void sendTraderDataFeedback(TraderData thisTrader, CommandSourceStack source) {
        String traderID = String.valueOf(thisTrader.getID());
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.traderid", EasyText.translatable(traderID, new Object[0]).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, traderID)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.traderid.copytooltip", new Object[0]))))), false);
        if (thisTrader.isPersistent()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.persistentid", thisTrader.getPersistentID()), false);
        }
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.type", thisTrader.type), false);
        if (thisTrader instanceof AuctionHouseTrader) {
            return;
        }
        if (thisTrader.getOwner().hasTeam()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner.team", thisTrader.getOwner().getTeam().getName(), thisTrader.getOwner().getTeam().getID()), false);
        } else if (thisTrader.getOwner().hasPlayer()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner", thisTrader.getOwner().getPlayer().getName(false), thisTrader.getOwner().getPlayer().id.toString()), false);
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.owner.custom", thisTrader.getOwner().getOwnerName(false)), false);
        }
        if (!thisTrader.isPersistent()) {
            String dimension = thisTrader.getLevel().m_135782_().toString();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.dimension", dimension), false);
            BlockPos pos = thisTrader.getPos();
            String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
            String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.position", EasyText.literal(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.position.teleporttooltip", new Object[0]))))), true);
        }
        if (thisTrader.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.list.name", thisTrader.getName()), true);
        }
    }

    static int deleteTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity entity;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TraderSaveData.DeleteTrader(trader.getID());
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.universaldata.delete.success", trader.getName()), true);
        if (source.m_81373_() != null && (entity = source.m_81373_()) instanceof Player) {
            Player player = (Player)entity;
            new SPacketDebugTrader(trader.getID()).sendTo(player);
        }
        return 1;
    }

    static int debugTraderData(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        EasyText.sendCommandSucess(source, (Component)EasyText.literal(trader.save().m_7916_()), false);
        if (((CommandSourceStack)commandContext.getSource()).m_230897_()) {
            new SPacketDebugTrader(trader.getID()).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
        }
        return 1;
    }

    static int addToTraderWhitelist(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        TraderData trader = TraderArgument.getTrader(commandContext, "traderID");
        TradeRule rule = TradeRule.getRule(PlayerWhitelist.TYPE.type, trader.getRules());
        if (rule instanceof PlayerWhitelist) {
            PlayerWhitelist whitelist = (PlayerWhitelist)rule;
            Collection players = EntityArgument.m_91477_(commandContext, (String)"player");
            int count = 0;
            for (ServerPlayer player : players) {
                if (!whitelist.addToWhitelist((Player)player)) continue;
                ++count;
            }
            int c = count;
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.traderdata.add_whitelist.success", c, trader.getName()), true);
            if (count > 0) {
                trader.markTradeRulesDirty();
            }
            return count;
        }
        EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.traderdata.add_whitelist.missingrule", new Object[0]));
        return 0;
    }

    static int replaceWalletSlotWithDefault(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, true);
    }

    static int replaceWalletSlot(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandLCAdmin.replaceWalletSlotInternal(commandContext, BoolArgumentType.getBool(commandContext, (String)"keepWalletContents"));
    }

    static int replaceWalletSlotInternal(CommandContext<CommandSourceStack> commandContext, boolean keepWalletContents) throws CommandSyntaxException {
        int count = 0;
        ItemInput input = ItemArgument.m_120963_(commandContext, (String)"wallet");
        if (!(input.m_120979_() instanceof WalletItem) && input.m_120979_() != Items.f_41852_) {
            throw new CommandSyntaxException(new CommandExceptionType(){}, (Message)EasyText.translatable("command.lightmanscurrency.lcadmin.replaceWalletSlot.notawallet", new Object[0]));
        }
        for (Entity entity : EntityArgument.m_91461_(commandContext, (String)"entity")) {
            ItemStack oldWallet;
            ItemStack newWallet;
            IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler(entity);
            if (walletHandler == null || (newWallet = input.m_120980_(1, true)).m_41619_() && walletHandler.getWallet().m_41619_()) continue;
            if (keepWalletContents && WalletItem.isWallet(oldWallet = walletHandler.getWallet())) {
                newWallet.m_41751_(oldWallet.m_41784_().m_6426_());
            }
            walletHandler.setWallet(newWallet);
        }
        return count;
    }

    static int openServerTax(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        TaxEntry entry = TaxSaveData.GetServerTaxEntry(false);
        if (entry != null) {
            entry.openMenu((Player)((CommandSourceStack)commandContext.getSource()).m_81375_(), SimpleValidator.NULL);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.openServerTax.error", new Object[0]));
        return 0;
    }

    static int listTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.title", new Object[0]), false);
        for (TaxEntry entry : TaxSaveData.GetAllTaxEntries(false)) {
            CommandLCAdmin.sendTaxDataFeedback(entry, source);
        }
        return 1;
    }

    private static void sendTaxDataFeedback(TaxEntry taxEntry, CommandSourceStack source) {
        if (taxEntry.isServerEntry()) {
            return;
        }
        String id = String.valueOf(taxEntry.getID());
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.id", EasyText.literal(id).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, id)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.id.copytooltip", new Object[0]))))), false);
        if (taxEntry.getOwner().hasTeam()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.owner.team", taxEntry.getOwner().getTeam().getName(), taxEntry.getOwner().getTeam().getID()), false);
        } else if (taxEntry.getOwner().hasPlayer()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.owner", taxEntry.getOwner().getPlayer().getName(false), taxEntry.getOwner().getPlayer().id.toString()), false);
        }
        String dimension = taxEntry.getArea().getCenter().getDimension().m_135782_().toString();
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.dimension", dimension), false);
        BlockPos pos = taxEntry.getArea().getCenter().getPos();
        String position = pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
        String teleportPosition = pos.m_123341_() + " " + (pos.m_123342_() + 1) + " " + pos.m_123343_();
        EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.position", EasyText.literal(position).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/execute in " + dimension + " run tp @s " + teleportPosition)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.position.teleporttooltip", new Object[0]))))), true);
        if (taxEntry.isInfiniteRange()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.infinite_range", new Object[0]), false);
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.radius", taxEntry.getRadius()), false);
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.height", taxEntry.getHeight()), false);
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.offset", taxEntry.getVertOffset()), false);
        }
        if (taxEntry.forcesAcceptance()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.force_acceptance", new Object[0]), false);
        }
        if (taxEntry.hasCustomName()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.list.name", taxEntry.getName()), true);
        }
    }

    static int deleteTaxCollector(CommandContext<CommandSourceStack> commandContext) {
        long taxCollectorID = LongArgumentType.getLong(commandContext, (String)"taxCollectorID");
        TaxEntry entry = TaxSaveData.GetTaxEntry(taxCollectorID, false);
        if (entry == null || entry.isServerEntry()) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.delete.fail", new Object[0]));
            return 0;
        }
        TaxSaveData.RemoveEntry(taxCollectorID);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.taxdata.delete.success", entry.getName()), true);
        return 1;
    }

    static int forceDisableTaxCollectors(CommandContext<CommandSourceStack> commandContext) {
        int count = 0;
        for (TaxEntry entry : TaxSaveData.GetAllTaxEntries(false)) {
            if (!entry.isActive()) continue;
            entry.setActive(false, null);
            ++count;
        }
        if (count > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.forceDisableTaxCollectors.success", count), true);
        } else {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.forceDisableTaxCollectors.fail", new Object[0]));
        }
        return count;
    }

    static int giveEventReward(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        if (!((Boolean)LCConfig.COMMON.eventAdvancementRewards.get()).booleanValue()) {
            return 0;
        }
        int success = 0;
        int count = IntegerArgumentType.getInteger(commandContext, (String)"count");
        ItemStack reward = ItemArgument.m_120963_(commandContext, (String)"item").m_120980_(count, false);
        for (ServerPlayer player : EntityArgument.m_91477_(commandContext, (String)"player")) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)reward.m_41777_());
            ++success;
        }
        return success;
    }

    static int listUnlockedEvents(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        IEventUnlocks eventUnlocks = CapabilityEventUnlocks.getCapability((Player)player);
        if (eventUnlocks != null) {
            List<String> unlocks = eventUnlocks.getUnlockedList();
            if (!unlocks.isEmpty()) {
                StringBuilder list = new StringBuilder();
                for (String v : eventUnlocks.getUnlockedList()) {
                    if (!list.isEmpty()) {
                        list.append(", ");
                    }
                    list.append(v);
                }
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(list.toString()), false);
            } else {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.event.list.none", new Object[0]), false);
            }
            return 1;
        }
        return 0;
    }

    static int unlockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        if (CapabilityEventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.event.unlock.fail", event));
            return 0;
        }
        CapabilityEventUnlocks.unlock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.event.unlock.success", event), false);
        return 1;
    }

    static int lockEvent(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        String event;
        ServerPlayer player = EntityArgument.m_91474_(commandContext, (String)"player");
        if (!CapabilityEventUnlocks.isUnlocked((Player)player, event = StringArgumentType.getString(commandContext, (String)"event"))) {
            EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.event.lock.fail", event));
            return 0;
        }
        CapabilityEventUnlocks.lock((Player)player, event);
        EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcadmin.event.lock.success", event), false);
        return 1;
    }
}

