/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketEditListConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketReloadConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketResetConfig;
import io.github.lightman314.lightmanscurrency.network.message.config.SPacketViewConfig;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandConfig {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder configReloadCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcconfig").then(Commands.m_82127_((String)"reload").executes(CommandConfig::reload))).then(CommandConfig.configEditCommands())).then(CommandConfig.configResetCommands())).then(CommandConfig.configViewCommands());
        dispatcher.register(configReloadCommand);
    }

    static int reload(CommandContext<CommandSourceStack> commandContext) {
        ServerPlayer player;
        int result = 0;
        boolean involveAdmins = false;
        if (((CommandSourceStack)commandContext.getSource()).m_6761_(2)) {
            involveAdmins = true;
            CoinAPI.API.ReloadCoinDataFromFile();
            ConfigFile.reloadServerFiles();
            TraderSaveData.ReloadPersistentTraders();
            ++result;
        }
        if ((player = ((CommandSourceStack)commandContext.getSource()).m_230896_()) != null) {
            SPacketReloadConfig.INSTANCE.sendTo(player);
            ++result;
        }
        if (result > 0) {
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.reload", new Object[0]), involveAdmins);
        }
        return result;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configEditCommands() {
        LiteralArgumentBuilder edit = Commands.m_82127_((String)"edit");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileName()).requires(stack -> file.isClientOnly() ? stack.m_230897_() : stack.m_6761_(2));
            file.getAllOptions().forEach((key, option) -> {
                if (option instanceof ListOption) {
                    fileSection.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, -1, true))))).then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), true)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CommandConfig.commandEditList((CommandContext<CommandSourceStack>)context, file, key, IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), false)))));
                } else {
                    fileSection.then(Commands.m_82127_((String)key).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> CommandConfig.commandEdit((CommandContext<CommandSourceStack>)context, file, key))));
                }
            });
            edit.then((ArgumentBuilder)fileSection);
        }
        return edit;
    }

    static int commandEdit(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        String input = StringArgumentType.getString(commandContext, (String)"value");
        if (file.isClientOnly()) {
            new SPacketEditConfig(file.getFileName(), configOption, input).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            Pair<Boolean, ConfigParsingException> result = option.load(input, ConfigOption.LoadSource.COMMAND);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.parse", ((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", option.getName(), input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.missing", new Object[0]));
        return 0;
    }

    static int commandEditList(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption, int listIndex, boolean isEdit) throws CommandSyntaxException {
        ConfigOption<?> configOption2;
        String input = isEdit ? StringArgumentType.getString(commandContext, (String)"value") : "";
        if (file.isClientOnly()) {
            new SPacketEditListConfig(file.getFileName(), configOption, input, listIndex, isEdit).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption) && (configOption2 = optionMap.get(configOption)) instanceof ListOption) {
            ListOption option = (ListOption)configOption2;
            Pair<Boolean, ConfigParsingException> result = option.editList(input, listIndex, isEdit);
            if (!((Boolean)result.getFirst()).booleanValue()) {
                EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.parse", ((ConfigParsingException)result.getSecond()).getMessage()));
                return 0;
            }
            if (!isEdit) {
                EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.list.remove.success", configOption + "[" + listIndex + "]"), true);
            }
            if (listIndex < 0) {
                listIndex = ((List)option.get()).size() - 1;
            }
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", configOption + "[" + listIndex + "]", input), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.missing", new Object[0]));
        return 0;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> configResetCommands() {
        LiteralArgumentBuilder view = Commands.m_82127_((String)"reset");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileName()).requires(stack -> file.isClientOnly() ? stack.m_230897_() : stack.m_6761_(2));
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.m_82127_((String)key).executes(context -> CommandConfig.commandReset((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandReset(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketResetConfig(file.getFileName(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            option.setToDefault();
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.success", option.getName(), option.write()), true);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.edit.fail.missing", new Object[0]));
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> configViewCommands() {
        LiteralArgumentBuilder view = Commands.m_82127_((String)"view");
        for (ConfigFile file : ConfigFile.getAvailableFiles()) {
            LiteralArgumentBuilder fileSection = (LiteralArgumentBuilder)Commands.m_82127_((String)file.getFileName()).requires(stack -> stack.m_230897_() || !file.isClientOnly());
            file.getAllOptions().forEach((key, option) -> fileSection.then(Commands.m_82127_((String)key).executes(context -> CommandConfig.commandView((CommandContext<CommandSourceStack>)context, file, key))));
            view.then((ArgumentBuilder)fileSection);
        }
        return view;
    }

    static int commandView(CommandContext<CommandSourceStack> commandContext, ConfigFile file, String configOption) throws CommandSyntaxException {
        if (file.isClientOnly()) {
            new SPacketViewConfig(file.getFileName(), configOption).sendTo(((CommandSourceStack)commandContext.getSource()).m_81375_());
            return 1;
        }
        Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
        if (optionMap.containsKey(configOption)) {
            ConfigOption<?> option = optionMap.get(configOption);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.view", option.getName()), false);
            EasyText.sendCommandSucess((CommandSourceStack)commandContext.getSource(), (Component)EasyText.literal(option.write()), false);
            return 1;
        }
        EasyText.sendCommandFail((CommandSourceStack)commandContext.getSource(), (Component)EasyText.translatable("command.lightmanscurrency.lcconfig.view.fail.missing", new Object[0]));
        return 0;
    }
}

