/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.source.builtin.PlayerBankAccountSource;
import io.github.lightman314.lightmanscurrency.api.money.bank.source.builtin.TeamBankAccountSource;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.common.commands.arguments.MoneyValueArgument;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandBank {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder bankCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcbank").requires(stack -> stack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"give").then(Commands.m_82127_((String)"allPlayers").then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::giveAllPlayers)))).then(Commands.m_82127_((String)"allTeams").then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::giveAllTeams)))).then(Commands.m_82127_((String)"players").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::givePlayers))))).then(Commands.m_82127_((String)"team").then(Commands.m_82129_((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::giveTeam)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"take").then(Commands.m_82127_((String)"allPlayers").then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::takeAllPlayers)))).then(Commands.m_82127_((String)"allTeams").then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::takeAllTeams)))).then(Commands.m_82127_((String)"players").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::takePlayers))))).then(Commands.m_82127_((String)"team").then(Commands.m_82129_((String)"teamID", (ArgumentType)LongArgumentType.longArg((long)0L)).then(Commands.m_82129_((String)"amount", (ArgumentType)MoneyValueArgument.argument(context)).executes(CommandBank::takeTeam)))));
        dispatcher.register(bankCommand);
    }

    static int giveAllPlayers(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), PlayerBankAccountSource.INSTANCE.CollectAllReferences(false), amount);
    }

    static int giveAllTeams(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), TeamSaveData.GetAllTeams(false).stream().filter(Team::hasBankAccount).map(Team::getBankReference).toList(), amount);
    }

    static int givePlayers(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.giveTo((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_(commandContext, (String)"players").stream().map(PlayerBankReference::of).toList(), amount);
    }

    static int giveTeam(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        Team team = TeamSaveData.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.team.noteam", teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.team.nobank", teamID));
            return 0;
        }
        return CommandBank.giveTo(source, Lists.newArrayList((Object[])new BankReference[]{team.getBankReference()}), amount);
    }

    static int giveTo(CommandSourceStack source, List<BankReference> accounts, MoneyValue amount) {
        int count = 0;
        MutableComponent bankName = null;
        for (BankReference account : accounts) {
            if (!BankAPI.API.BankDepositFromServer(account.get(), amount) || ++count != 1) continue;
            bankName = account.get().getName();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.give.fail", new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.give.success.single", amount.getText("NULL"), bankName), true);
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.give.success", amount.getText("NULL"), count), true);
        }
        return count;
    }

    static int takeAllPlayers(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), PlayerBankAccountSource.INSTANCE.CollectAllReferences(false), amount);
    }

    static int takeAllTeams(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), TeamBankAccountSource.INSTANCE.CollectAllReferences(false), amount);
    }

    static int takePlayers(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_(commandContext, (String)"players").stream().map(PlayerBankReference::of).toList(), amount);
    }

    static int takeTeam(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        long teamID = LongArgumentType.getLong(commandContext, (String)"teamID");
        MoneyValue amount = MoneyValueArgument.getMoneyValue(commandContext, "amount");
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        Team team = TeamSaveData.GetTeam(false, teamID);
        if (team == null) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.team.noteam", teamID));
            return 0;
        }
        if (!team.hasBankAccount()) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.team.nobank", teamID));
            return 0;
        }
        return CommandBank.takeFrom((CommandSourceStack)commandContext.getSource(), Lists.newArrayList((Object[])new BankReference[]{team.getBankReference()}), amount);
    }

    static int takeFrom(CommandSourceStack source, List<BankReference> accounts, MoneyValue amount) {
        int count = 0;
        MutableComponent bankName = null;
        MoneyValue largestAmount = MoneyValue.empty();
        for (BankReference account : accounts) {
            Pair<Boolean, MoneyValue> result = BankAPI.API.BankWithdrawFromServer(account.get(), amount);
            if (!((Boolean)result.getFirst()).booleanValue()) continue;
            if (++count == 1) {
                bankName = account.get().getName();
            }
            if (((MoneyValue)result.getSecond()).getCoreValue() <= largestAmount.getCoreValue()) continue;
            largestAmount = (MoneyValue)result.getSecond();
        }
        if (count < 1) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.take.fail", new Object[0]));
        } else if (count == 1) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.take.success.single", largestAmount.getText("NULL"), bankName), true);
        } else {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcbank.take.success", largestAmount.getText("NULL"), count), true);
        }
        return count;
    }
}

