/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.reference;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IEasyEntityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AuctionStandBlock
extends Block
implements IEasyEntityBlock {
    public AuctionStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return LazyShapes.BOX_T;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        TraderData ah;
        if (!level.f_46443_ && AuctionHouseTrader.isEnabled() && (ah = TraderSaveData.GetAuctionHouse(false)) != null) {
            ah.openTraderMenu(player, BlockValidator.of(pos, this));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nonnull
    public Collection<BlockEntityType<?>> getAllowedTypes() {
        return Lists.newArrayList((Object[])new BlockEntityType[]{(BlockEntityType)ModBlockEntities.AUCTION_STAND.get()});
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new AuctionStandBlockEntity(pos, state);
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity blockEntity;
        super.m_5707_(level, pos, state, player);
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof AuctionStandBlockEntity) {
            AuctionStandBlockEntity be = (AuctionStandBlockEntity)blockEntity;
            be.dropItem = false;
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        if (state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, flag);
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AuctionStandBlockEntity) {
            AuctionStandBlockEntity be = (AuctionStandBlockEntity)blockEntity;
            if (be.dropItem) {
                InventoryUtil.dumpContents(level, pos, new ItemStack((ItemLike)this));
            }
        }
    }
}

