/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class CardDisplayBlock
extends TraderBlockRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 4;
    private final String name;
    private final Color color;

    public CardDisplayBlock(@Nonnull BlockBehaviour.Properties properties, @Nonnull String name, @Nonnull Color color) {
        super(properties);
        this.name = name;
        this.color = color;
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 4);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.ITEM_TRADER.get();
    }

    @Override
    public List<BlockEntityType<?>> validTraderTypes() {
        return ImmutableList.of((Object)((BlockEntityType)ModBlockEntities.ITEM_TRADER.get()));
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }

    @Nonnull
    public String m_7705_() {
        return this.name;
    }

    @Override
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.colored_item", this.color.getComponent()));
        super.m_5871_(stack, level, tooltip, flagIn);
    }
}

