/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.advancements.date;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.advancements.date.DatePredicate;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class DateTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("lightmanscurrency", "date_range");
    public static final DateTrigger INSTANCE = new DateTrigger();

    private DateTrigger() {
    }

    public static AbstractCriterionTriggerInstance ofRange(int startMonth, int startDate, int endMonth, int endDate) {
        return new Instance(EntityPredicate.Composite.f_36667_, new DatePredicate(startMonth, startDate), new DatePredicate(endMonth, endDate));
    }

    public static AbstractCriterionTriggerInstance ofRange(@Nonnull DatePredicate startDate, @Nonnull DatePredicate endDate) {
        return new Instance(EntityPredicate.Composite.f_36667_, startDate, endDate);
    }

    @Nonnull
    protected Instance createInstance(@Nonnull JsonObject json, @Nonnull EntityPredicate.Composite predicate, @Nonnull DeserializationContext context) {
        return new Instance(predicate, DatePredicate.fromJson(json.get("start")), DatePredicate.fromJson(json.get("end")));
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(@Nonnull ServerPlayer player) {
        this.m_66234_(player, Instance::test);
    }

    protected static class Instance
    extends AbstractCriterionTriggerInstance {
        private final DatePredicate startDate;
        private final DatePredicate endDate;

        public Instance(EntityPredicate.Composite playerPred, DatePredicate startDate, DatePredicate endDate) {
            super(ID, playerPred);
            this.startDate = startDate;
            this.endDate = endDate;
        }

        @Nonnull
        public JsonObject m_7683_(@Nonnull SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.add("start", (JsonElement)this.startDate.toJson());
            json.add("end", (JsonElement)this.endDate.toJson());
            return json;
        }

        public boolean test() {
            return DatePredicate.isInRange(this.startDate, this.endDate);
        }
    }
}

