/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import io.github.lightman314.lightmanscurrency.client.util.LCRenderTypes;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OutlineUtil {
    public static Vector4f decodeColor(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, alpha);
    }

    public static Vector4f decodeColor(int color) {
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float a = (float)(color & 0xFF) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, int color, float alpha) {
        OutlineUtil.renderBox(pose, buffer, area, OutlineUtil.decodeColor(color, alpha));
    }

    public static void renderBox(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, @Nonnull AABB area, Vector4f color) {
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        float inflate = 0.015625f;
        if (area.m_82390_(camera)) {
            inflate *= -1.0f;
        }
        Vector3f minPos = new Vector3f((float)area.f_82288_ - inflate, (float)area.f_82289_ - inflate, (float)area.f_82290_ - inflate);
        Vector3f maxPos = new Vector3f((float)area.f_82291_ + inflate, (float)area.f_82292_ + inflate, (float)area.f_82293_ + inflate);
        OutlineUtil.renderBoxFaces(pose, buffer, minPos, maxPos, color);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109608_((PoseStack)pose, (VertexConsumer)consumer, (double)minPos.m_122239_(), (double)minPos.m_122260_(), (double)minPos.m_122269_(), (double)maxPos.m_122239_(), (double)maxPos.m_122260_(), (double)maxPos.m_122269_(), (float)color.m_123601_(), (float)color.m_123615_(), (float)color.m_123616_(), (float)1.0f);
    }

    private static void renderBoxFaces(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, Vector3f minPos, Vector3f maxPos, Vector4f color) {
        PoseStack.Pose pose = poseStack.m_85850_();
        VertexConsumer consumer = buffer.m_6299_(LCRenderTypes.getOutlineTranslucent());
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.DOWN, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.UP, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.NORTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.SOUTH, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.EAST, color);
        OutlineUtil.renderBoxFace(pose, consumer, minPos, maxPos, Direction.WEST, color);
    }

    private static void renderBoxFace(@Nonnull PoseStack.Pose pose, @Nonnull VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color) {
        Vector3f pos0 = new Vector3f();
        Vector3f pos1 = new Vector3f();
        Vector3f pos2 = new Vector3f();
        Vector3f pos3 = new Vector3f();
        Vector3f normal = new Vector3f();
        float minX = minPos.m_122239_();
        float minY = minPos.m_122260_();
        float minZ = minPos.m_122269_();
        float maxX = maxPos.m_122239_();
        float maxY = maxPos.m_122260_();
        float maxZ = maxPos.m_122269_();
        switch (face) {
            case DOWN: {
                pos0.m_122245_(maxX, minY, minZ);
                pos1.m_122245_(maxX, minY, maxZ);
                pos2.m_122245_(minX, minY, maxZ);
                pos3.m_122245_(minX, minY, minZ);
                normal.m_122245_(0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                pos0.m_122245_(minX, maxY, minZ);
                pos1.m_122245_(minX, maxY, maxZ);
                pos2.m_122245_(maxX, maxY, maxZ);
                pos3.m_122245_(maxX, maxY, minZ);
                normal.m_122245_(0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                pos0.m_122245_(maxX, maxY, minZ);
                pos1.m_122245_(maxX, minY, minZ);
                pos2.m_122245_(minX, minY, minZ);
                pos3.m_122245_(minX, maxY, minZ);
                normal.m_122245_(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                pos0.m_122245_(minX, maxY, maxZ);
                pos1.m_122245_(minX, minY, maxZ);
                pos2.m_122245_(maxX, minY, maxZ);
                pos3.m_122245_(maxX, maxY, maxZ);
                normal.m_122245_(0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                pos0.m_122245_(minX, maxY, minZ);
                pos1.m_122245_(minX, minY, minZ);
                pos2.m_122245_(minX, minY, maxZ);
                pos3.m_122245_(minX, maxY, maxZ);
                normal.m_122245_(-1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                pos0.m_122245_(maxX, maxY, maxZ);
                pos1.m_122245_(maxX, minY, maxZ);
                pos2.m_122245_(maxX, minY, minZ);
                pos3.m_122245_(maxX, maxY, minZ);
                normal.m_122245_(1.0f, 0.0f, 0.0f);
            }
        }
        Matrix4f posMatrix = pose.m_85861_();
        Vector4f posTransformTemp = new Vector4f(pos0.m_122239_(), pos0.m_122260_(), pos0.m_122269_(), 1.0f);
        posTransformTemp.m_123602_(pos0.m_122239_(), pos0.m_122260_(), pos0.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x0 = posTransformTemp.m_123601_();
        double y0 = posTransformTemp.m_123615_();
        double z0 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos1.m_122239_(), pos1.m_122260_(), pos1.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x1 = posTransformTemp.m_123601_();
        double y1 = posTransformTemp.m_123615_();
        double z1 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos2.m_122239_(), pos2.m_122260_(), pos2.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x2 = posTransformTemp.m_123601_();
        double y2 = posTransformTemp.m_123615_();
        double z2 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos3.m_122239_(), pos3.m_122260_(), pos3.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x3 = posTransformTemp.m_123601_();
        double y3 = posTransformTemp.m_123615_();
        double z3 = posTransformTemp.m_123616_();
        float r = color.m_123601_();
        float g = color.m_123615_();
        float b = color.m_123616_();
        float a = color.m_123617_();
        Vector3f normalTransformTemp = new Vector3f();
        normalTransformTemp.m_122245_(normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        normalTransformTemp.m_122249_(pose.m_85864_());
        float nx = normalTransformTemp.m_122239_();
        float ny = normalTransformTemp.m_122260_();
        float nz = normalTransformTemp.m_122269_();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 2.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(nx, ny, nz).m_5752_();
    }
}

