/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;

public class IconAndButtonUtil {
    public static final ResourceLocation ICON_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/icons.png");
    public static final ResourceLocation WIDGET_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/widgets.png");
    public static final IconData ICON_TRADER = IconData.of(ModItems.TRADING_CORE);
    public static final IconData ICON_TRADER_ALT = IconData.of(ICON_TEXTURE, 80, 0);
    public static final IconData ICON_STORAGE = IconData.of((ItemLike)Items.f_42009_);
    public static final IconData ICON_COLLECT_COINS = IconData.of(ICON_TEXTURE, 0, 0);
    public static final IconData ICON_STORE_COINS = IconData.of(ICON_TEXTURE, 16, 0);
    public static final IconData ICON_TRADE_RULES = IconData.of((ItemLike)Items.f_42517_);
    public static final IconData ICON_SETTINGS = IconData.of(ICON_TEXTURE, 32, 0);
    public static final IconData ICON_BACK = IconData.of(ICON_TEXTURE, 0, 16);
    public static final IconData ICON_LEFT = IconData.of(ICON_TEXTURE, 16, 16);
    public static final IconData ICON_RIGHT = IconData.of(ICON_TEXTURE, 32, 16);
    public static final IconData ICON_UP = IconData.of(ICON_TEXTURE, 112, 16);
    public static final IconData ICON_DOWN = IconData.of(ICON_TEXTURE, 128, 16);
    public static final IconData ICON_SHOW_LOGGER = IconData.of((ItemLike)Items.f_42614_);
    public static final IconData ICON_CLEAR_LOGGER = IconData.of(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
    private static final IconData ICON_CREATIVE_ON = IconData.of(ICON_TEXTURE, 48, 16);
    private static final IconData ICON_CREATIVE_OFF = IconData.of(ICON_TEXTURE, 64, 16);
    public static final IconData ICON_PERSISTENT_DATA = IconData.of(ICON_TEXTURE, 80, 16);
    private static final IconData ICON_INTERFACE_ON = IconData.of((ItemLike)Items.f_41978_);
    private static final IconData ICON_INTERFACE_OFF = IconData.of((ItemLike)Items.f_42000_);
    public static final IconData ICON_PLUS = IconData.of(ICON_TEXTURE, 0, 32);
    public static final IconData ICON_X = IconData.of(ICON_TEXTURE, 16, 32);
    public static final IconData ICON_WHITELIST = IconData.of(ICON_TEXTURE, 32, 32);
    public static final IconData ICON_BLACKLIST = IconData.of(ICON_TEXTURE, 48, 32);
    public static final IconData ICON_COUNT = IconData.of(ICON_TEXTURE, 64, 32);
    public static final IconData ICON_COUNT_PLAYER = IconData.of(ICON_TEXTURE, 80, 32);
    public static final IconData ICON_TIMED_SALE = IconData.of((ItemLike)Items.f_42524_);
    public static final IconData ICON_DISCOUNT_LIST = IconData.of(ICON_TEXTURE, 96, 32);
    public static final IconData ICON_FREE_SAMPLE = IconData.of(ICON_TEXTURE, 112, 32);
    public static final IconData ICON_PRICE_FLUCTUATION = IconData.of(ICON_TEXTURE, 128, 32);
    public static final IconData ICON_TRADELIST = IconData.of(ICON_TEXTURE, 48, 0);
    public static final IconData ICON_MODE_DISABLED = IconData.of((ItemLike)Items.f_42127_);
    public static final IconData ICON_MODE_REDSTONE_OFF = IconData.of(ICON_TEXTURE, 64, 0);
    public static final IconData ICON_MODE_REDSTONE = IconData.of((ItemLike)Items.f_41978_);
    public static final IconData ICON_MODE_ALWAYS_ON = IconData.of((ItemLike)Items.f_42153_);
    public static final IconData ICON_CHECKMARK = IconData.of(ICON_TEXTURE, 0, 48);
    public static final IconData ICON_ALEX_HEAD;
    public static final IconData ICON_TAXES;
    public static final Sprite SPRITE_PLUS;
    public static final Sprite SPRITE_MINUS;
    public static final Sprite SPRITE_CHECK_ACTIVE;
    public static final Sprite SPRITE_CHECK_INACTIVE;
    public static final IconData ICON_ONLINEMODE_TRUE;
    public static final IconData ICON_ONLINEMODE_FALSE;
    public static final Component TOOLTIP_TRADER;
    public static final Component TOOLTIP_STORAGE;
    public static final String TOOLTIP_COLLECT_COINS = "tooltip.lightmanscurrency.trader.collectcoins";
    public static final Component TOOLTIP_STORE_COINS;
    public static final Component TOOLTIP_BACK_TO_TERMINAL;
    public static final Component TOOLTIP_TRADE_RULES;
    public static final MutableComponent TOOLTIP_TRADE_RULES_TRADER;
    public static final MutableComponent TOOLTIP_TRADE_RULES_TRADE;
    public static final Component TOOLTIP_OPEN_SETTINGS;
    public static final Component TOOLTIP_CANNOT_BE_UNDONE;
    public static final Component TOOLTIP_CREATIVE_ENABLE;
    public static final Component TOOLTIP_CREATIVE_DISABLE;
    public static final Component TOOLTIP_INTERFACE_ENABLE;
    public static final Component TOOLTIP_INTERFACE_DISABLE;
    public static final Component TOOLTIP_PERSISTENT_TRADER;
    public static final Component TOOLTIP_PERSISTENT_AUCTION;

    public static NonNullFunction<IconButton, IconData> ICON_CREATIVE(NonNullSupplier<Boolean> isCreative) {
        return b -> {
            boolean creative = b.m_198029_() != ((Boolean)isCreative.get()).booleanValue();
            return creative ? ICON_CREATIVE_ON : ICON_CREATIVE_OFF;
        };
    }

    public static NonNullSupplier<IconData> ICON_INTERFACE_ACTIVE(NonNullSupplier<Boolean> isActive) {
        return () -> (Boolean)isActive.get() != false ? ICON_INTERFACE_ON : ICON_INTERFACE_OFF;
    }

    public static IconData GetIcon(TraderInterfaceBlockEntity.ActiveMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case TraderInterfaceBlockEntity.ActiveMode.DISABLED -> ICON_MODE_DISABLED;
            case TraderInterfaceBlockEntity.ActiveMode.REDSTONE_OFF -> ICON_MODE_REDSTONE_OFF;
            case TraderInterfaceBlockEntity.ActiveMode.REDSTONE_ONLY -> ICON_MODE_REDSTONE;
            case TraderInterfaceBlockEntity.ActiveMode.ALWAYS_ON -> ICON_MODE_ALWAYS_ON;
        };
    }

    public static IconButton traderButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_TRADER).withAddons(EasyAddonHelper.tooltip(TOOLTIP_TRADER));
    }

    public static IconButton storageButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_STORAGE).withAddons(EasyAddonHelper.tooltip(TOOLTIP_STORAGE));
    }

    public static IconButton storageButton(int x, int y, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> visiblityCheck) {
        return IconAndButtonUtil.storageButton(x, y, pressable).withAddons(EasyAddonHelper.visibleCheck(visiblityCheck));
    }

    public static IconButton collectCoinButton(int x, int y, Consumer<EasyButton> pressable, Player player, Supplier<TraderData> traderSource) {
        return new IconButton(x, y, pressable, ICON_COLLECT_COINS).withAddons(EasyAddonHelper.tooltips(() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader != null && !trader.hasBankAccount() && !trader.getStoredMoney().getStoredMoney().isEmpty()) {
                ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
                result.add(EasyText.translatable(TOOLTIP_COLLECT_COINS, new Object[0]));
                IMoneyHolder storage = trader.getStoredMoney();
                for (MoneyValue value : storage.getStoredMoney().allValues()) {
                    result.add(value.getText());
                }
                return result;
            }
            return new ArrayList();
        }), EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return trader.hasPermission(player, "collectCoins") && !trader.hasBankAccount();
        })), EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
            TraderData trader = (TraderData)traderSource.get();
            if (trader == null) {
                return false;
            }
            return !trader.getInternalStoredMoney().isEmpty();
        })));
    }

    public static IconButton collectCoinButtonAlt(int x, int y, Consumer<EasyButton> pressable, Supplier<MoneyStorage> moneyStorageSource) {
        return IconAndButtonUtil.collectCoinButtonAlt(ScreenPosition.of(x, y), pressable, moneyStorageSource);
    }

    public static IconButton collectCoinButtonAlt(ScreenPosition pos, Consumer<EasyButton> pressable, Supplier<MoneyStorage> moneyStorageSource) {
        return new IconButton(pos.x, pos.y, pressable, ICON_COLLECT_COINS).withAddons(EasyAddonHelper.tooltips(() -> {
            MoneyStorage storage = (MoneyStorage)moneyStorageSource.get();
            if (storage != null && !storage.isEmpty()) {
                ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
                result.add(EasyText.translatable(TOOLTIP_COLLECT_COINS, new Object[0]));
                for (MoneyValue value : storage.allValues()) {
                    result.add(value.getText());
                }
                return result;
            }
            return new ArrayList();
        }));
    }

    public static IconButton storeCoinButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_STORE_COINS).withAddons(EasyAddonHelper.tooltip(TOOLTIP_STORE_COINS));
    }

    public static IconButton leftButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_LEFT);
    }

    public static IconButton rightButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_RIGHT);
    }

    public static PlainButton plusButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return IconAndButtonUtil.plusButton(pos.x, pos.y, pressable);
    }

    public static PlainButton plusButton(int x, int y, Consumer<EasyButton> pressable) {
        return new PlainButton(x, y, pressable, SPRITE_PLUS);
    }

    public static PlainButton minusButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return IconAndButtonUtil.minusButton(pos.x, pos.y, pressable);
    }

    public static PlainButton minusButton(int x, int y, Consumer<EasyButton> pressable) {
        return new PlainButton(x, y, pressable, SPRITE_MINUS);
    }

    public static IconButton backToTerminalButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_BACK).withAddons(EasyAddonHelper.tooltip(TOOLTIP_BACK_TO_TERMINAL));
    }

    public static IconButton backToTerminalButton(int x, int y, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> visibilityCheck) {
        return new IconButton(x, y, pressable, ICON_BACK).withAddons(EasyAddonHelper.tooltip(TOOLTIP_BACK_TO_TERMINAL), EasyAddonHelper.visibleCheck(visibilityCheck));
    }

    public static IconButton tradeRuleButton(int x, int y, Consumer<EasyButton> pressable) {
        return new IconButton(x, y, pressable, ICON_TRADE_RULES).withAddons(EasyAddonHelper.tooltip((Component)TOOLTIP_TRADE_RULES_TRADE));
    }

    public static IconButton creativeToggleButton(ScreenPosition pos, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> isCreative) {
        return IconAndButtonUtil.creativeToggleButton(pos.x, pos.y, pressable, isCreative);
    }

    public static IconButton creativeToggleButton(int x, int y, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> isCreative) {
        return new IconButton(x, y, pressable, IconAndButtonUtil.ICON_CREATIVE(isCreative)).withAddons(EasyAddonHelper.toggleTooltip(isCreative, TOOLTIP_CREATIVE_DISABLE, TOOLTIP_CREATIVE_ENABLE));
    }

    public static IconButton interfaceActiveToggleButton(int x, int y, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> isActive) {
        return new IconButton(x, y, pressable, IconAndButtonUtil.ICON_INTERFACE_ACTIVE(isActive)).withAddons(EasyAddonHelper.toggleTooltip(isActive, TOOLTIP_INTERFACE_DISABLE, TOOLTIP_INTERFACE_ENABLE));
    }

    public static PlainButton quickInsertButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return new PlainButton(pos, pressable, Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 224, 0, 10, 10));
    }

    public static PlainButton quickExtractButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        return new PlainButton(pos, pressable, Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 234, 0, 10, 10));
    }

    public static PlainButton checkmarkButton(ScreenPosition pos, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> isActive) {
        return IconAndButtonUtil.checkmarkButton(pos.x, pos.y, pressable, isActive);
    }

    public static PlainButton checkmarkButton(int x, int y, Consumer<EasyButton> pressable, NonNullSupplier<Boolean> isActive) {
        return new PlainButton(x, y, pressable, (NonNullSupplier<Sprite>)((NonNullSupplier)() -> (Boolean)isActive.get() != false ? SPRITE_CHECK_ACTIVE : SPRITE_CHECK_INACTIVE));
    }

    public static DropdownWidget interactionTypeDropdown(ScreenPosition pos, int width, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        return IconAndButtonUtil.interactionTypeDropdown(pos.x, pos.y, width, currentlySelected, onSelect, blacklist);
    }

    public static DropdownWidget interactionTypeDropdown(int x, int y, int width, TraderInterfaceBlockEntity.InteractionType currentlySelected, Consumer<Integer> onSelect, List<TraderInterfaceBlockEntity.InteractionType> blacklist) {
        ArrayList<Component> options = new ArrayList<Component>();
        for (int i = 0; i < TraderInterfaceBlockEntity.InteractionType.size(); ++i) {
            options.add(TraderInterfaceBlockEntity.InteractionType.fromIndex(i).getDisplayText());
        }
        return new DropdownWidget(x, y, width, currentlySelected.index, onSelect, index -> !blacklist.contains((Object)TraderInterfaceBlockEntity.InteractionType.fromIndex(index)), options);
    }

    static {
        ICON_TAXES = IconData.of(ICON_TEXTURE, 96, 0);
        SPRITE_PLUS = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 224, 20, 10, 10);
        SPRITE_MINUS = Sprite.SimpleSprite(TraderScreen.GUI_TEXTURE, 234, 20, 10, 10);
        SPRITE_CHECK_ACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 10, 200, 10, 10);
        SPRITE_CHECK_INACTIVE = Sprite.SimpleSprite(WIDGET_TEXTURE, 10, 220, 10, 10);
        ICON_ONLINEMODE_TRUE = IconData.of((ItemLike)Items.f_42680_);
        ICON_ONLINEMODE_FALSE = ICON_CHECKMARK;
        TOOLTIP_TRADER = EasyText.translatable("tooltip.lightmanscurrency.trader.opentrades", new Object[0]);
        TOOLTIP_STORAGE = EasyText.translatable("tooltip.lightmanscurrency.trader.openstorage", new Object[0]);
        TOOLTIP_STORE_COINS = EasyText.translatable("tooltip.lightmanscurrency.trader.storecoins", new Object[0]);
        TOOLTIP_BACK_TO_TERMINAL = EasyText.translatable("tooltip.lightmanscurrency.trader.universaltrader.back", new Object[0]);
        TOOLTIP_TRADE_RULES = EasyText.translatable("tooltip.lightmanscurrency.trader.traderules", new Object[0]);
        TOOLTIP_TRADE_RULES_TRADER = EasyText.translatable("tooltip.lightmanscurrency.trader.traderules.trader", new Object[0]);
        TOOLTIP_TRADE_RULES_TRADE = EasyText.translatable("tooltip.lightmanscurrency.trader.traderules.trade", new Object[0]);
        TOOLTIP_OPEN_SETTINGS = EasyText.translatable("tooltip.lightmanscurrency.trader.settings", new Object[0]);
        TOOLTIP_CANNOT_BE_UNDONE = EasyText.translatable("tooltip.lightmanscurrency.warning", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW});
        TOOLTIP_CREATIVE_ENABLE = EasyText.translatable("tooltip.lightmanscurrency.trader.creative.enable", new Object[0]);
        TOOLTIP_CREATIVE_DISABLE = EasyText.translatable("tooltip.lightmanscurrency.trader.creative.disable", new Object[0]);
        TOOLTIP_INTERFACE_ENABLE = EasyText.translatable("tooltip.lightmanscurrency.interface.enable", new Object[0]);
        TOOLTIP_INTERFACE_DISABLE = EasyText.translatable("tooltip.lightmanscurrency.interface.disable", new Object[0]);
        TOOLTIP_PERSISTENT_TRADER = EasyText.translatable("tooltip.lightmanscurrency.persistent.add.trader", new Object[0]);
        TOOLTIP_PERSISTENT_AUCTION = EasyText.translatable("tooltip.lightmanscurrency.persistent.add.auction", new Object[0]);
        ItemStack alexHead = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag headData = new CompoundTag();
        CompoundTag skullOwner = new CompoundTag();
        skullOwner.m_128385_("Id", new int[]{-731408145, -304985227, -1778597514, 158507129});
        CompoundTag properties = new CompoundTag();
        ListTag textureList = new ListTag();
        CompoundTag texture = new CompoundTag();
        texture.m_128359_("Value", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjNiMDk4OTY3MzQwZGFhYzUyOTI5M2MyNGUwNDkxMDUwOWIyMDhlN2I5NDU2M2MzZWYzMWRlYzdiMzc1MCJ9fX0=");
        textureList.add((Object)texture);
        properties.m_128365_("textures", (Tag)textureList);
        skullOwner.m_128365_("Properties", (Tag)properties);
        headData.m_128365_("SkullOwner", (Tag)skullOwner);
        alexHead.m_41751_(headData);
        ICON_ALEX_HEAD = IconData.of(alexHead);
    }
}

