/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Quaternion;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RotationHandler {
    public static final String SPINNING = "SPINNING";
    public static final String FACING = "FACING";
    public static final String FACING_UP = "FACING_UP";
    private static final Map<String, RotationHandler> ROTATION_HANDLERS = new HashMap<String, RotationHandler>();

    @Nullable
    public static RotationHandler getRotationHandler(@Nonnull String type) {
        return ROTATION_HANDLERS.get(type);
    }

    @Nonnull
    protected abstract List<Quaternion> rotate(@Nonnull BlockState var1, float var2);

    public static void debugRegisteredHandlers() {
        StringBuilder values = new StringBuilder();
        ROTATION_HANDLERS.forEach((key, handler) -> {
            if (!values.isEmpty()) {
                values.append(", ");
            }
            values.append((String)key);
        });
        LightmansCurrency.LogDebug("Registered Rotation Handlers: " + values);
    }

    public static void registerRotationHandler(@Nonnull String typeName, @Nonnull RotationHandler handler) {
        if (ROTATION_HANDLERS.containsKey(typeName)) {
            LightmansCurrency.LogWarning("Could not register duplicate rotation handler '" + typeName + "'!");
            return;
        }
        ROTATION_HANDLERS.put(typeName, handler);
    }

    static {
        ROTATION_HANDLERS.put(SPINNING, new RotationHandler(){

            @Override
            @Nonnull
            protected List<Quaternion> rotate(@Nonnull BlockState state, float partialTicks) {
                return ImmutableList.of((Object)ItemTraderBlockEntityRenderer.getRotation(partialTicks));
            }
        });
        ROTATION_HANDLERS.put(FACING, new RotationHandler(){

            @Override
            @Nonnull
            protected List<Quaternion> rotate(@Nonnull BlockState state, float partialTicks) {
                Block block = state.m_60734_();
                if (block instanceof IRotatableBlock) {
                    IRotatableBlock rb = (IRotatableBlock)block;
                    int facing = rb.getFacing(state).m_122416_();
                    return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f));
                }
                return ImmutableList.of();
            }
        });
        ROTATION_HANDLERS.put(FACING_UP, new RotationHandler(){

            @Override
            @Nonnull
            protected List<Quaternion> rotate(@Nonnull BlockState state, float partialTicks) {
                Block block = state.m_60734_();
                if (block instanceof IRotatableBlock) {
                    IRotatableBlock rb = (IRotatableBlock)block;
                    int facing = rb.getFacing(state).m_122416_();
                    return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing * -90.0f), (Object)MathUtil.fromAxisAngleDegree(MathUtil.getXP(), 90.0f));
                }
                return ImmutableList.of((Object)MathUtil.fromAxisAngleDegree(MathUtil.getXP(), 90.0f));
            }
        });
    }
}

