/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionData;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.ItemPositionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPositionBlockManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ItemPositionBlockManager INSTANCE = new ItemPositionBlockManager();
    private final Map<ResourceLocation, BlockEntry> data = new HashMap<ResourceLocation, BlockEntry>();

    private ItemPositionBlockManager() {
        super(GSON, "lightmanscurrency/item_position_blocks");
    }

    @Nullable
    public static ResourceLocation getResourceForBlock(@Nonnull BlockState state) {
        return ItemPositionBlockManager.getResourceForBlock(state.m_60734_());
    }

    @Nullable
    public static ResourceLocation getResourceForBlock(@Nonnull Block block) {
        for (BlockEntry d : ItemPositionBlockManager.INSTANCE.data.values()) {
            if (!d.isInList(block)) continue;
            return d.target;
        }
        return null;
    }

    @Nonnull
    public static ItemPositionData getDataForBlock(@Nonnull BlockState state) {
        return ItemPositionBlockManager.getDataForBlock(state.m_60734_());
    }

    @Nonnull
    public static ItemPositionData getDataForBlock(@Nonnull Block block) {
        ResourceLocation dataID = ItemPositionBlockManager.getResourceForBlock(block);
        if (dataID != null) {
            return ItemPositionManager.getDataOrEmpty(dataID);
        }
        return ItemPositionData.EMPTY;
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> map, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller filler) {
        this.data.clear();
        map.forEach((id, json) -> {
            try {
                JsonObject root = GsonHelper.m_13918_((JsonElement)json, (String)"top element");
                ResourceLocation target = new ResourceLocation(GsonHelper.m_13851_((JsonObject)root, (String)"target", (String)id.toString()));
                JsonArray valueList = GsonHelper.m_13933_((JsonObject)root, (String)"values");
                ArrayList<Predicate<Block>> results = new ArrayList<Predicate<Block>>();
                for (int i = 0; i < valueList.size(); ++i) {
                    String value = GsonHelper.m_13805_((JsonElement)valueList.get(i), (String)("values[" + i + "]"));
                    if (value.startsWith("#")) {
                        results.add(new TagPredicate(new ResourceLocation(value.substring(1))));
                        continue;
                    }
                    results.add(new BlockPredicate(new ResourceLocation(value)));
                }
                this.data.put((ResourceLocation)id, new BlockEntry(target, results));
            }
            catch (JsonSyntaxException | IllegalArgumentException | ResourceLocationException exception) {
                LightmansCurrency.LogError("Parsing error loading item position data " + id, exception);
            }
        });
        LightmansCurrency.LogDebug("Loaded " + this.data.size() + " Item Position Block entries!");
    }

    private record BlockEntry(@Nonnull ResourceLocation target, @Nonnull List<Predicate<Block>> list) {
        boolean isInList(@Nonnull Block block) {
            return this.list.stream().anyMatch(p -> p.test(block));
        }
    }

    private record TagPredicate(@Nonnull ResourceLocation tag) implements Predicate<Block>
    {
        @Override
        public boolean test(Block block) {
            return ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)this.tag)).contains((Object)block);
        }
    }

    private record BlockPredicate(@Nonnull ResourceLocation blockID) implements Predicate<Block>
    {
        @Override
        public boolean test(Block block) {
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
            return id.equals((Object)this.blockID);
        }
    }
}

