/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class FreezerTraderBlockEntityRenderer
implements BlockEntityRenderer<FreezerTraderBlockEntity> {
    public FreezerTraderBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public void render(@NotNull FreezerTraderBlockEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(tileEntity, partialTicks, poseStack, bufferSource, lightLevel, id);
        Block block = tileEntity.m_58900_().m_60734_();
        if (block instanceof FreezerBlock) {
            FreezerBlock freezerBlock = (FreezerBlock)block;
            poseStack.m_85836_();
            Direction facing = freezerBlock.getFacing(tileEntity.m_58900_());
            Vector3f corner = IRotatableBlock.getOffsetVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f hinge = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.96875f), MathUtil.VectorMult(forward, 0.21875f));
            Quaternion rotation = MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing.m_122416_() * -90.0f + 90.0f * tileEntity.getDoorAngle(partialTicks));
            poseStack.m_85837_((double)hinge.m_122239_(), (double)hinge.m_122260_(), (double)hinge.m_122269_());
            poseStack.m_85845_(rotation);
            Minecraft mc = Minecraft.m_91087_();
            BakedModel model = mc.m_91304_().getModel(freezerBlock.getDoorModel());
            ItemRenderer itemRenderer = mc.m_91291_();
            itemRenderer.m_115143_(new ItemStack((ItemLike)freezerBlock), ItemTransforms.TransformType.FIXED, false, poseStack, bufferSource, lightLevel, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
        }
    }
}

