/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.data.ClientTaxData;
import io.github.lightman314.lightmanscurrency.client.util.OutlineUtil;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="lightmanscurrency")
public class TaxBlockRenderer {
    @SubscribeEvent
    public static void onLevelRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            PoseStack pose = event.getPoseStack();
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            double cameraX = event.getCamera().m_90583_().m_7096_();
            double cameraY = event.getCamera().m_90583_().m_7098_();
            double cameraZ = event.getCamera().m_90583_().m_7094_();
            for (TaxEntry entry : ClientTaxData.GetAllTaxEntries()) {
                if (!TaxBlockRenderer.shouldRenderEntry(entry, (Level)level, (Player)player, event.getCamera().m_90583_())) continue;
                pose.m_85836_();
                int radius = entry.getRadius();
                int height = entry.getHeight();
                int vertOffset = entry.getVertOffset();
                AABB renderArea = new AABB((double)(-radius), (double)vertOffset, (double)(-radius), (double)radius + 1.0, (double)(vertOffset + height), (double)radius + 1.0);
                BlockPos center = entry.getCenter().getPos();
                pose.m_85837_((double)center.m_123341_() - cameraX, (double)center.m_123342_() - cameraY, (double)center.m_123343_() - cameraZ);
                OutlineUtil.renderBox(pose, (MultiBufferSource)buffer, renderArea, entry.getRenderColor((Player)player), 0.1f);
                pose.m_85849_();
            }
        }
    }

    private static boolean shouldRenderEntry(@Nonnull TaxEntry entry, @Nonnull Level level, @Nonnull Player player, @Nonnull Vec3 cameraPos) {
        BlockPos center = entry.getCenter().getPos();
        double renderDistance = 256.0 + (double)entry.getRadius();
        return entry.shouldRender(player) && entry.getCenter().sameDimension(level) && center.m_203198_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_) <= renderDistance * renderDistance;
    }
}

