/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class TradeButton
extends EasyButton
implements ITooltipSource {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trade.png");
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 18;
    public static final int TEMPLATE_WIDTH = 212;
    public static final int BUTTON_HEIGHT = 18;
    private final Supplier<TradeData> tradeSource;
    private final Supplier<TradeContext> contextSource;
    public boolean displayOnly = false;

    public TradeData getTrade() {
        return this.tradeSource.get();
    }

    public TradeRenderManager<?> getTradeRenderer() {
        TradeData trade = this.getTrade();
        if (trade != null) {
            return trade.getButtonRenderer();
        }
        return null;
    }

    public TradeContext getContext() {
        return this.contextSource.get();
    }

    public TradeButton(@Nonnull Supplier<TradeContext> contextSource, @Nonnull Supplier<TradeData> tradeSource, Consumer<EasyButton> press) {
        super(0, 0, 0, 18, press);
        this.tradeSource = tradeSource;
        this.contextSource = contextSource;
        this.recalculateSize();
    }

    @Override
    public TradeButton withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    private void recalculateSize() {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr != null) {
            TradeContext context = this.getContext();
            this.m_93674_(tr.tradeButtonWidth(context));
        }
    }

    @Deprecated
    public void move(int x, int y) {
        this.setPosition(x, y);
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        this.recalculateSize();
        this.renderBackground(gui, !context.isStorageMode && !this.displayOnly && this.f_93622_);
        LazyOptional<ScreenPosition> arrowPosOptional = tr.arrowPosition(context);
        arrowPosOptional.ifPresent(arrowPos -> this.renderArrow(gui, (ScreenPosition)arrowPos, !context.isStorageMode && !this.displayOnly && this.f_93622_));
        try {
            tr.renderAdditional(this, gui, context);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error on additional Trade Button rendering.", e);
        }
        this.renderAlert(gui, tr.alertPosition(context), tr.getAlertData(context));
        this.renderDisplays(gui, tr, context);
        gui.resetColor();
    }

    private void renderBackground(@Nonnull EasyGuiGraphics gui, boolean isHovered) {
        int xRend;
        if (this.f_93618_ < 8) {
            LightmansCurrency.LogError("Cannot renderBG a trade button that is less than 8 pixels wide!");
            return;
        }
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.blit(GUI_TEXTURE, 0, 0, 0, vOffset, 4, 18);
        for (int xOff = 4; xOff < this.f_93618_ - 4; xOff += xRend) {
            xRend = Math.min(this.f_93618_ - 4 - xOff, 204);
            gui.blit(GUI_TEXTURE, xOff, 0, 4, vOffset, xRend, 18);
        }
        gui.blit(GUI_TEXTURE, this.f_93618_ - 4, 0, 208, vOffset, 4, 18);
    }

    private void renderArrow(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, boolean isHovered) {
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int vOffset = isHovered ? 18 : 0;
        gui.blit(GUI_TEXTURE, position, 212, vOffset, 22, 18);
    }

    private void renderAlert(@Nonnull EasyGuiGraphics gui, @Nonnull ScreenPosition position, @Nullable List<AlertData> alerts) {
        if (alerts == null || alerts.size() == 0) {
            return;
        }
        alerts.sort(AlertData::compare);
        alerts.get(0).setShaderColor(gui, this.f_93623_ ? 1.0f : 0.5f);
        gui.blit(GUI_TEXTURE, position, 234, 0, 22, 18);
    }

    public void renderDisplays(EasyGuiGraphics gui, TradeRenderManager<?> tr, TradeContext context) {
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            ((DisplayEntry)display.getFirst()).render(gui, 0, 0, (DisplayData)display.getSecond());
        }
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        List<AlertData> alerts;
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        TradeRenderManager<?> tr = this.getTradeRenderer();
        if (tr == null) {
            return null;
        }
        TradeContext context = this.getContext();
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.tryAddTooltip(tooltips, tr.getAdditionalTooltips(context, mouseX - this.getX(), mouseY - this.getY()));
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getInputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.getX(), this.getY(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        for (Pair<DisplayEntry, DisplayData> display : TradeButton.getOutputDisplayData(tr, context)) {
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.getX(), this.getY(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            this.tryAddTooltip(tooltips, ((DisplayEntry)display.getFirst()).getTooltip());
        }
        if (this.isMouseOverAlert(mouseX, mouseY, tr, context) && (alerts = tr.getAlertData(context)) != null && alerts.size() > 0) {
            this.tryAddAlertTooltips(tooltips, alerts);
        }
        if (tooltips.size() == 0) {
            return null;
        }
        return tooltips;
    }

    private void tryAddTooltip(@Nonnull List<Component> tooltips, @Nullable List<Component> add) {
        if (add == null) {
            return;
        }
        tooltips.addAll(add);
    }

    private void tryAddAlertTooltips(@Nonnull List<Component> tooltips, @Nullable List<AlertData> alerts) {
        if (alerts == null) {
            return;
        }
        alerts.sort(AlertData::compare);
        for (AlertData alert : alerts) {
            tooltips.add((Component)alert.getFormattedMessage());
        }
    }

    public void onInteractionClick(int mouseX, int mouseY, int button, TradeButtonArea.InteractionConsumer consumer) {
        if (!this.f_93624_ || !this.m_5953_(mouseX, mouseY)) {
            return;
        }
        TradeData trade = this.getTrade();
        if (trade == null) {
            return;
        }
        TradeRenderManager<?> tr = trade.getButtonRenderer();
        if (tr == null) {
            return;
        }
        TradeContext context = this.getContext();
        List<Pair<DisplayEntry, DisplayData>> inputDisplays = TradeButton.getInputDisplayData(tr, context);
        for (int i = 0; i < inputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = inputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.getX(), this.getY(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonInputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        List<Pair<DisplayEntry, DisplayData>> outputDisplays = TradeButton.getOutputDisplayData(tr, context);
        for (int i = 0; i < outputDisplays.size(); ++i) {
            Pair<DisplayEntry, DisplayData> display = outputDisplays.get(i);
            if (!((DisplayEntry)display.getFirst()).isMouseOver(this.getX(), this.getY(), (DisplayData)display.getSecond(), mouseX, mouseY)) continue;
            consumer.onTradeButtonOutputInteraction(context.getTrader(), trade, i, button);
            return;
        }
        consumer.onTradeButtonInteraction(context.getTrader(), trade, mouseX - this.getX(), mouseY - this.getY(), button);
    }

    public boolean isMouseOverAlert(int mouseX, int mouseY, TradeRenderManager<?> tr, TradeContext context) {
        ScreenPosition position = tr.alertPosition(context);
        int left = this.getX() + position.x;
        int top = this.getY() + position.y;
        return mouseX >= left && mouseX < left + 22 && mouseY >= top && mouseY < top + 18;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getInputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getInputDisplays(context);
        List<DisplayData> display = tr.inputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    public static List<Pair<DisplayEntry, DisplayData>> getOutputDisplayData(TradeRenderManager<?> tr, TradeContext context) {
        ArrayList<Pair<DisplayEntry, DisplayData>> results = new ArrayList<Pair<DisplayEntry, DisplayData>>();
        List<DisplayEntry> entries = tr.getOutputDisplays(context);
        List<DisplayData> display = tr.outputDisplayArea(context).divide(entries.size());
        for (int i = 0; i < entries.size() && i < display.size(); ++i) {
            results.add((Pair<DisplayEntry, DisplayData>)Pair.of((Object)entries.get(i), (Object)display.get(i)));
        }
        return results;
    }

    @Override
    protected boolean m_7972_(int button) {
        if (this.getContext().isStorageMode || this.displayOnly) {
            return false;
        }
        return super.m_7972_(button);
    }
}

