/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NetworkTraderButton
extends EasyButton
implements ITooltipWidget {
    public static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("lightmanscurrency", "textures/gui/universaltraderbuttons.png");
    public static final int WIDTH = 146;
    public static final int HEIGHT = 30;
    TraderData data;
    public boolean selected = false;

    public TraderData getData() {
        return this.data;
    }

    public NetworkTraderButton(ScreenPosition pos, Consumer<EasyButton> pressable) {
        this(pos.x, pos.y, pressable);
    }

    public NetworkTraderButton(int x, int y, Consumer<EasyButton> pressable) {
        super(x, y, 146, 30, pressable);
    }

    @Override
    public NetworkTraderButton withAddons(WidgetAddon ... addons) {
        this.withAddonsInternal(addons);
        return this;
    }

    public void SetData(TraderData data) {
        this.data = data;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        boolean bl = this.f_93623_ = this.data != null && !this.selected;
        if (this.data == null) {
            return;
        }
        if (this.f_93623_) {
            gui.resetColor();
        } else {
            gui.setColor(0.5f, 0.5f, 0.5f);
        }
        int offset = 0;
        if (this.f_93622_ || this.selected) {
            offset = 30;
        }
        gui.blit(BUTTON_TEXTURES, 0, 0, 0, offset, 146, 30);
        this.data.getIcon().render(gui, 4, 7);
        Style style = this.data.isCreative() ? Style.f_131099_.m_131157_(ChatFormatting.GREEN) : Style.f_131099_;
        gui.drawString(TextRenderUtil.fitString((Component)this.data.getName(), this.f_93618_ - 26, style), 24, 6, 0x404040);
        gui.drawString(TextRenderUtil.fitString(this.data.getOwner().getOwnerName(true), this.f_93618_ - 26), 24, 16, 0x404040);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public List<Component> getTooltipText() {
        TraderData trader = this.getData();
        if (trader == null) {
            return new ArrayList<Component>();
        }
        return trader.getTerminalInfo((Player)Minecraft.m_91087_().f_91074_);
    }
}

