/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketChestQuickCollect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class ChestCoinCollectButton
extends IconButton {
    private static ChestCoinCollectButton lastButton;
    private final ContainerScreen screen;

    public ChestCoinCollectButton(ContainerScreen screen) {
        super(0, 0, (EasyButton b) -> CPacketChestQuickCollect.sendToServer(), (NonNullSupplier<IconData>)((NonNullSupplier)ChestCoinCollectButton::getIcon));
        this.screen = screen;
        lastButton = this;
        this.setPosition(this.screen.getGuiLeft() + this.screen.getXSize() - this.f_93618_, this.screen.getGuiTop() - this.f_93619_);
    }

    private static IconData getIcon() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null) {
            return IconData.of(CoinAPI.API.getEquippedWallet((Player)mc.f_91074_));
        }
        return IconData.BLANK;
    }

    private boolean shouldBeVisible() {
        ItemStack wallet;
        if (!((Boolean)LCConfig.CLIENT.chestButtonVisible.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && WalletItem.isWallet(wallet = CoinAPI.API.getEquippedWallet((Player)mc.f_91074_))) {
            boolean allowSideChains = (Boolean)LCConfig.CLIENT.chestButtonAllowSideChains.get();
            Container container = ((ChestMenu)this.screen.m_6262_()).m_39261_();
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (!CoinAPI.API.IsCoin(container.m_8020_(i), allowSideChains)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderTick() {
        super.renderTick();
        this.f_93624_ = this.shouldBeVisible();
    }

    public static void tryRenderTooltip(EasyGuiGraphics gui, int mouseX, int mouseY) {
        if (lastButton != null && lastButton.m_5953_(mouseX, mouseY)) {
            gui.renderTooltip((Component)EasyText.translatable("tooltip.button.chest.coin_collection", new Object[0]), mouseX, mouseY);
        }
    }
}

