/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.IEasyTickable;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyViewer;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankInteraction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BankAccountWidget
implements IEasyTickable {
    public static final int HEIGHT = 109;
    public static final int BUTTON_WIDTH = 70;
    private final IBankAccountWidget parent;
    private final MoneyValueWidget amountSelection;
    private final EasyButton buttonDeposit;
    private final EasyButton buttonWithdraw;
    int y;
    int spacing;
    public boolean allowEmptyDeposits = true;

    public MoneyValueWidget getAmountSelection() {
        return this.amountSelection;
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, Consumer<Object> addWidget) {
        this(y, parent, 0, addWidget);
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, int spacing, Consumer<Object> addWidget) {
        this.parent = parent;
        this.y = y;
        this.spacing = spacing;
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        this.amountSelection = new MoneyValueWidget(screenMiddle - 88, this.y, null, MoneyValue.empty(), value -> {});
        this.amountSelection.allowFreeInput = false;
        addWidget.accept((Object)this.amountSelection);
        this.buttonDeposit = new EasyTextButton(screenMiddle - 5 - 70, this.y + 69 + 5 + spacing, 70, 20, (Component)EasyText.translatable("gui.button.bank.deposit", new Object[0]), this::OnDeposit);
        addWidget.accept((Object)this.buttonDeposit);
        this.buttonWithdraw = new EasyTextButton(screenMiddle + 5, this.y + 69 + 5 + spacing, 70, 20, (Component)EasyText.translatable("gui.button.bank.withdraw", new Object[0]), this::OnWithdraw);
        addWidget.accept((Object)this.buttonWithdraw);
        this.buttonWithdraw.f_93623_ = false;
        this.buttonDeposit.f_93623_ = false;
    }

    public void renderInfo(@Nonnull EasyGuiGraphics gui) {
        this.renderInfo(gui, 0);
    }

    public void renderInfo(@Nonnull EasyGuiGraphics gui, int yOffset) {
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        IBankAccount ba = this.parent.getBankAccount();
        MutableComponent balanceComponent = ba == null ? EasyText.translatable("gui.lightmanscurrency.bank.null", new Object[0]) : EasyText.translatable("gui.lightmanscurrency.bank.balance", ba.getMoneyStorage().getRandomValueText());
        int offset = gui.font.m_92895_(balanceComponent.getString()) / 2;
        gui.pushOffsetZero().drawString((Component)balanceComponent, screenMiddle - offset, this.y + 69 + 30 + this.spacing + yOffset, 0x404040);
        gui.popOffset();
    }

    @Override
    public void tick() {
        if (this.parent.getBankAccount() == null) {
            this.buttonWithdraw.f_93623_ = false;
            this.buttonDeposit.f_93623_ = false;
        } else {
            this.buttonDeposit.f_93623_ = !this.parent.getCoinAccess().getStoredMoney().isEmpty() && (this.allowEmptyDeposits || !this.amountSelection.getCurrentValue().isEmpty());
            this.buttonWithdraw.f_93623_ = !this.amountSelection.getCurrentValue().isEmpty();
        }
    }

    private void OnDeposit(EasyButton button) {
        new CPacketBankInteraction(true, this.amountSelection.getCurrentValue()).send();
        this.amountSelection.changeValue(MoneyValue.empty());
    }

    private void OnWithdraw(EasyButton button) {
        new CPacketBankInteraction(false, this.amountSelection.getCurrentValue()).send();
        this.amountSelection.changeValue(MoneyValue.empty());
    }

    public static interface IBankAccountWidget {
        public Font getFont();

        public Screen getScreen();

        public IBankAccount getBankAccount();

        public IMoneyViewer getCoinAccess();
    }
}

