/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.message.teams.CPacketCreateTeam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TeamSelectionTab
extends TeamTab {
    TeamSelectWidget teamSelection;
    List<Team> teamList = new ArrayList<Team>();
    EditBox newTeamName;
    EasyButton buttonCreateTeam;

    public TeamSelectionTab(TeamManagerScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    @NotNull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.team.selection");
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.refreshTeamList();
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 20), 5, () -> this.teamList, this::getActiveTeam, this::selectTeamButton));
        this.newTeamName = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 140, 160, 20, (Component)Component.m_237119_()));
        this.newTeamName.m_94199_(32);
        this.buttonCreateTeam = this.addChild(new EasyTextButton(screenArea.pos.offset(120, 165), 60, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.team.create", new Object[0]), this::createTeam));
        this.buttonCreateTeam.f_93623_ = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private void refreshTeamList() {
        this.teamList = new ArrayList<Team>();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.team.select", new Object[0]), 20, 10, 0x404040);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.team.create", new Object[0]), 20, 130, 0x404040);
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonCreateTeam.f_93623_ = !this.newTeamName.m_94155_().isBlank();
    }

    private void selectTeamButton(int teamIndex) {
        Team team = this.getTeam(teamIndex);
        if (team != null) {
            if (this.screen.getActiveTeam() == team) {
                this.screen.setActiveTeam(-1L);
            } else {
                this.screen.setActiveTeam(team.getID());
            }
        }
    }

    private void createTeam(EasyButton button) {
        if (this.newTeamName.m_94155_().isEmpty()) {
            return;
        }
        new CPacketCreateTeam(this.newTeamName.m_94155_()).send();
        this.newTeamName.m_94144_("");
    }
}

