/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TeamMemberListTab
extends TeamTab {
    ScrollTextDisplay memberDisplay;

    public TeamMemberListTab(TeamManagerScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.team.members", new Object[0]);
    }

    @Override
    public boolean allowViewing(Player player, Team team) {
        return team != null;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.memberDisplay = this.addChild(new ScrollTextDisplay(screenArea.pos.offset(10, 10), screenArea.width - 20, screenArea.height - 20, (Supplier<List<? extends Component>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<Component> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            list.add(team.getOwner().getNameComponent(true).m_130940_(ChatFormatting.GREEN));
            team.getAdmins().forEach(admin -> list.add(admin.getNameComponent(true).m_130940_(ChatFormatting.DARK_GREEN)));
            team.getMembers().forEach(member -> list.add(member.getNameComponent(true)));
        }
        return list;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }
}

