/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletBankMenu;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SelectionTab
extends WalletBankTab {
    EasyButton buttonPersonalAccount;
    TeamSelectWidget teamSelection;

    public SelectionTab(WalletBankScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    @NotNull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.selection", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(79, 15), 5, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.buttonPersonalAccount = this.addChild(new EasyTextButton(screenArea.pos.offset(7, 15), 70, 20, (Component)EasyText.translatable("gui.button.bank.playeraccount", new Object[0]), this::PressPersonalAccount));
        this.tick();
    }

    private boolean isSelfSelected() {
        return ((WalletBankMenu)this.screen.m_6262_()).getBankAccount() == PlayerBankReference.of(((WalletBankMenu)this.screen.m_6262_()).getPlayer()).get();
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((WalletBankMenu)this.screen.m_6262_()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        BankReference bankReference = ((WalletBankMenu)this.screen.m_6262_()).getBankAccountReference();
        if (bankReference instanceof TeamBankReference) {
            TeamBankReference teamBankReference = (TeamBankReference)bankReference;
            return TeamSaveData.GetTeam(true, teamBankReference.teamID);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            Team selectedTeam = this.selectedTeam();
            if (selectedTeam != null && team.getID() == this.selectedTeam().getID()) {
                return;
            }
            BankReference account = TeamBankReference.of(team).flagAsClient();
            new CPacketSelectBankAccount(account).send();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(EasyButton button) {
        BankReference account = PlayerBankReference.of(((WalletBankMenu)this.screen.m_6262_()).getPlayer());
        new CPacketSelectBankAccount(account).send();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)this.getTooltip(), 8, 6, 0x404040);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.getTeamList().size() == 0) {
            gui.pushOffset(this.teamSelection);
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (Component)EasyText.translatable("gui.lightmanscurrency.bank.noteamsavailable", new Object[0]), 1, TeamButton.Size.NARROW.width - 2, 1, this.teamSelection.m_93694_() - 2, 0xFFFFFF);
            gui.popOffset();
        }
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.f_93623_ = !this.isSelfSelected();
    }
}

