/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class TradeLimitTab
extends TradeRuleSubTab<TradeLimit> {
    EditBox limitInput;
    EasyButton buttonSetLimit;
    EasyButton buttonClearMemory;

    public TradeLimitTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, TradeLimit.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_COUNT;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.limitInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 19, 30, 20, (Component)EasyText.empty()));
        this.limitInput.m_94199_(3);
        TradeLimit rule = (TradeLimit)this.getRule();
        if (rule != null) {
            this.limitInput.m_94144_(Integer.toString(rule.getLimit()));
        }
        this.buttonSetLimit = this.addChild(new EasyTextButton(screenArea.pos.offset(41, 19), 40, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.setlimit", new Object[0]), this::PressSetLimitButton));
        this.buttonClearMemory = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 50), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.clearmemory", new Object[0]), this::PressClearMemoryButton).withAddons(EasyAddonHelper.tooltip((Component)EasyText.translatable("gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip", new Object[0]))));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TradeLimit rule = (TradeLimit)this.getRule();
        if (rule != null) {
            gui.drawString(EasyText.translatable("gui.button.lightmanscurrency.playerlimit.info", rule.getLimit()).getString(), 10, 9, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
    }

    void PressSetLimitButton(EasyButton button) {
        int limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
        TradeLimit rule = (TradeLimit)this.getRule();
        if (rule != null) {
            rule.setLimit(limit);
        }
        this.sendUpdateMessage(LazyPacketData.simpleInt("Limit", limit));
    }

    void PressClearMemoryButton(EasyButton button) {
        TradeLimit rule = (TradeLimit)this.getRule();
        if (rule != null) {
            rule.resetCount();
        }
        this.sendUpdateMessage(LazyPacketData.simpleFlag("ClearMemory"));
    }
}

