/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class PriceFluctuationTab
extends TradeRuleSubTab<PriceFluctuation> {
    EditBox fluctuationInput;
    EasyButton buttonSetFluctuation;
    TimeInputWidget durationInput;

    public PriceFluctuationTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, PriceFluctuation.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_PRICE_FLUCTUATION;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.fluctuationInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 25, screenArea.y + 9, 20, 20, (Component)EasyText.empty()));
        this.fluctuationInput.m_94199_(2);
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule != null) {
            this.fluctuationInput.m_94144_(Integer.toString(rule.getFluctuation()));
        }
        this.buttonSetFluctuation = this.addChild(new EasyTextButton(screenArea.pos.offset(125, 10), 50, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.discount.set", new Object[0]), this::PressSetFluctuationButton));
        this.durationInput = this.addChild(new TimeInputWidget(screenArea.pos.offset(63, 75), 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.MINUTE, this::onTimeSet));
        this.durationInput.setTime(((PriceFluctuation)this.getRule()).getDuration());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule == null) {
            return;
        }
        gui.pushOffset((AbstractWidget)this.fluctuationInput);
        gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.fluctuation.tooltip", new Object[0]), this.fluctuationInput.m_5711_() + 4, 3, 0xFFFFFF);
        gui.popOffset();
        TextRenderUtil.drawCenteredMultilineText(gui, (Component)EasyText.translatable("gui.button.lightmanscurrency.price_fluctuation.info", ((PriceFluctuation)this.getRule()).getFluctuation(), new TimeUtil.TimeData(((PriceFluctuation)this.getRule()).getDuration()).getShortString()), 10, this.screen.getXSize() - 20, 35, 0xFFFFFF);
    }

    @Override
    public void tick() {
        TextInputUtil.whitelistInteger(this.fluctuationInput, 1L, Integer.MAX_VALUE);
    }

    void PressSetFluctuationButton(EasyButton button) {
        int fluctuation = TextInputUtil.getIntegerValue(this.fluctuationInput, 1);
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule != null) {
            rule.setFluctuation(fluctuation);
        }
        this.sendUpdateMessage(LazyPacketData.simpleInt("Fluctuation", fluctuation));
    }

    public void onTimeSet(TimeUtil.TimeData newTime) {
        PriceFluctuation rule = (PriceFluctuation)this.getRule();
        if (rule != null) {
            rule.setDuration(newTime.miliseconds);
        }
        this.sendUpdateMessage(LazyPacketData.simpleLong("Duration", newTime.miliseconds));
    }
}

