/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRuleSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerBlacklist;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class PlayerBlacklistTab
extends TradeRuleSubTab<PlayerBlacklist> {
    EditBox nameInput;
    EasyButton buttonAddPlayer;
    EasyButton buttonRemovePlayer;
    ScrollTextDisplay playerDisplay;

    public PlayerBlacklistTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent, PlayerBlacklist.TYPE);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_BLACKLIST;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 9, screenArea.width - 20, 20, (Component)EasyText.empty()));
        this.buttonAddPlayer = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 30), 78, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.blacklist.add", new Object[0]), this::PressBlacklistButton));
        this.buttonRemovePlayer = this.addChild(new EasyTextButton(screenArea.pos.offset(screenArea.width - 88, 30), 78, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.blacklist.remove", new Object[0]), this::PressForgiveButton));
        this.playerDisplay = this.addChild(new ScrollTextDisplay(screenArea.pos.offset(7, 55), screenArea.width - 14, 84, (Supplier<List<? extends Component>>)((Supplier)this::getBlacklistedPlayers)));
        this.playerDisplay.setColumnCount(2);
    }

    private List<Component> getBlacklistedPlayers() {
        ArrayList playerList = Lists.newArrayList();
        PlayerBlacklist rule = (PlayerBlacklist)this.getRule();
        if (rule == null) {
            return playerList;
        }
        for (PlayerReference player : rule.getBannedPlayers()) {
            playerList.add(player.getNameComponent(true));
        }
        return playerList;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    void PressBlacklistButton(EasyButton button) {
        String name = this.nameInput.m_94155_();
        if (!name.isBlank()) {
            this.nameInput.m_94144_("");
            this.sendUpdateMessage(LazyPacketData.builder().setBoolean("Add", true).setString("Name", name));
        }
    }

    void PressForgiveButton(EasyButton button) {
        String name = this.nameInput.m_94155_();
        if (!name.isBlank()) {
            this.nameInput.m_94144_("");
            this.sendUpdateMessage(LazyPacketData.builder().setBoolean("Add", false).setString("Name", name));
        }
    }
}

