/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class RuleToggleTab
extends TradeRulesClientSubTab {
    private final List<EasyButton> toggleRuleButtons = new ArrayList<EasyButton>();

    public RuleToggleTab(@Nonnull TradeRulesClientTab<?> parent) {
        super(parent);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.toggleRuleButtons.clear();
        int count = this.getFilteredRules().size();
        for (int i = 0; i < count; ++i) {
            int index = i;
            this.toggleRuleButtons.add(this.addChild(IconAndButtonUtil.checkmarkButton(screenArea.pos.offset(20, 25 + 12 * i), this::PressManagerActiveButton, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> {
                List<TradeRule> rules = this.getFilteredRules();
                if (index < rules.size()) {
                    return rules.get(index).isActive();
                }
                return false;
            }))));
        }
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("traderule.list.blurb", new Object[0]).m_130940_(ChatFormatting.BOLD), 20, 10, 0xFFFFFF);
        List<TradeRule> rules = this.getFilteredRules();
        for (int i = 0; i < this.getFilteredRules().size(); ++i) {
            TradeRule rule = rules.get(i);
            MutableComponent name = rule.getName().m_130940_(rule.isActive() ? ChatFormatting.GREEN : ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
            gui.drawString((Component)name, 32, 26 + 12 * i, 0xFFFFFF);
        }
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("gui.button.lightmanscurrency.manager", new Object[0]);
    }

    void PressManagerActiveButton(EasyButton button) {
        List<TradeRule> rules;
        int ruleIndex = this.toggleRuleButtons.indexOf((Object)button);
        if (ruleIndex >= 0 && ruleIndex < (rules = this.getFilteredRules()).size()) {
            TradeRule rule = rules.get(ruleIndex);
            this.commonTab.EditTradeRule(rule.type, LazyPacketData.simpleBoolean("SetActive", !rule.isActive()));
        }
    }
}

