/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.permissions.PermissionOption;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PermissionsTab
extends SettingsSubTab {
    List<PermissionOption> options;

    public PermissionsTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    protected int startHeight() {
        return 5;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_41997_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.allyperms", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("editPermissions");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.options = new ArrayList<PermissionOption>();
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            this.options.addAll(trader.getPermissionOptions());
        }
        int startHeight = screenArea.y + this.startHeight();
        for (int i = 0; i < this.options.size(); ++i) {
            int xPos = this.getXPos(i) + screenArea.x;
            int yPos = this.getYPosOffset(i) + startHeight;
            PermissionOption option = this.options.get(i);
            option.initWidgets(this, xPos, yPos, this::addChild);
        }
    }

    private int getYPosOffset(int index) {
        int yIndex = index / 2;
        return 18 * yIndex;
    }

    private int getXPos(int index) {
        return index % 2 == 0 ? 5 : 105;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        int startHeight = this.startHeight();
        for (int i = 0; i < this.options.size(); ++i) {
            PermissionOption option = this.options.get(i);
            int xPos = this.getXPos(i) + option.widgetWidth();
            int yPos = this.getYPosOffset(i) + startHeight;
            int textWidth = 90 - option.widgetWidth();
            int textHeight = gui.font.m_92920_(option.widgetName().getString(), textWidth);
            int yStart = (20 - textHeight) / 2 + yPos;
            gui.drawWordWrap((Component)option.widgetName(), xPos, yStart, textWidth, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        for (PermissionOption option : this.options) {
            option.tick();
        }
    }

    @Override
    public boolean shouldRenderInventoryText() {
        return this.options.size() < 15;
    }
}

