/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AllyTab
extends SettingsSubTab {
    EditBox nameInput;
    EasyButton buttonAddAlly;
    EasyButton buttonRemoveAlly;
    ScrollTextDisplay display;

    public AllyTab(@Nonnull TraderSettingsClientTab parent) {
        super(parent);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.ally", new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("addRemoveAllies");
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.nameInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 20, screenArea.y + 10, 160, 20, (Component)EasyText.empty()));
        this.nameInput.m_94199_(16);
        this.buttonAddAlly = this.addChild(new EasyTextButton(screenArea.pos.offset(20, 35), 74, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.allies.add", new Object[0]), this::AddAlly));
        this.buttonRemoveAlly = this.addChild(new EasyTextButton(screenArea.pos.offset(screenArea.width - 93, 35), 74, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.allies.remove", new Object[0]), this::RemoveAlly));
        this.display = this.addChild(new ScrollTextDisplay(screenArea.pos.offset(5, 60), screenArea.width - 10, 75, (Supplier<List<? extends Component>>)((Supplier)this::getAllyList)));
        this.display.setColumnCount(2);
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    private List<Component> getAllyList() {
        ArrayList list = Lists.newArrayList();
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            trader.getAllies().forEach(ally -> list.add(ally.getNameComponent(true)));
        }
        return list;
    }

    @Override
    public void tick() {
        this.nameInput.m_94120_();
        this.buttonRemoveAlly.f_93623_ = !this.nameInput.m_94155_().isEmpty();
        this.buttonAddAlly.f_93623_ = this.buttonRemoveAlly.f_93623_;
    }

    private void AddAlly(EasyButton button) {
        String allyName = this.nameInput.m_94155_();
        this.sendMessage(LazyPacketData.simpleString("AddAlly", allyName));
        this.nameInput.m_94144_("");
    }

    private void RemoveAlly(EasyButton button) {
        String allyName = this.nameInput.m_94155_();
        this.sendMessage(LazyPacketData.simpleString("RemoveAlly", allyName));
        this.nameInput.m_94144_("");
    }
}

