/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.item;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DirectionalSettingsWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.blockentity.ItemTraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.ConfigurableSidedHandler;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemStorageClientTab
extends TraderInterfaceClientTab<ItemStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS = 8;
    private static final int ROWS = 2;
    private static final int WIDGET_OFFSET = 57;
    DirectionalSettingsWidget inputSettings;
    DirectionalSettingsWidget outputSettings;
    int scroll = 0;
    ScrollBarWidget scrollBar;

    public ItemStorageClientTab(TraderInterfaceScreen screen, ItemStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.interface.storage", new Object[0]);
    }

    private ConfigurableSidedHandler.DirectionalSettings getInputSettings() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemHandler().getInputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    private ConfigurableSidedHandler.DirectionalSettings getOutputSettings() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemHandler().getOutputSides();
        }
        return new ConfigurableSidedHandler.DirectionalSettings();
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.scrollBar = this.addChild(new ScrollBarWidget(screenArea.pos.offset(157, 17), 36, this));
        this.addChild(new ScrollListener(screenArea.pos, screenArea.width, 118, this));
        this.inputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(33, 66), this.getInputSettings()::get, this.getInputSettings().ignoreSides, this::ToggleInputSide, this::addChild);
        this.outputSettings = new DirectionalSettingsWidget(screenArea.pos.offset(116, 66), this.getOutputSettings()::get, this.getInputSettings().ignoreSides, this::ToggleOutputSide, this::addChild);
        this.addChild(IconAndButtonUtil.quickInsertButton(screenArea.pos.offset(22, 115), b -> ((ItemStorageTab)this.commonTab).quickTransfer(0)));
        this.addChild(IconAndButtonUtil.quickExtractButton(screenArea.pos.offset(34, 115), b -> ((ItemStorageTab)this.commonTab).quickTransfer(1)));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)EasyText.translatable("tooltip.lightmanscurrency.interface.storage", new Object[0]), 8, 6, 0x404040);
        TraderInterfaceBlockEntity traderInterfaceBlockEntity = this.menu.getBE();
        if (traderInterfaceBlockEntity instanceof ItemTraderInterfaceBlockEntity) {
            ItemTraderInterfaceBlockEntity be = (ItemTraderInterfaceBlockEntity)traderInterfaceBlockEntity;
            this.validateScroll();
            int index = this.scroll * 8;
            TraderItemStorage storage = be.getItemBuffer();
            int hoveredSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * 8;
            for (int y = 0; y < 2; ++y) {
                int n = 17 + y * 18;
                for (int x = 0; x < 8; ++x) {
                    int xPos = 13 + x * 18;
                    gui.resetColor();
                    gui.blit(TraderInterfaceScreen.GUI_TEXTURE, xPos, n, 206, 0, 18, 18);
                    if (index < storage.getSlotCount()) {
                        gui.renderItem(storage.getContents().get(index), xPos + 1, n + 1, this.getCountText(storage.getContents().get(index)));
                    }
                    if (index == hoveredSlot) {
                        gui.renderSlotHighlight(xPos + 1, n + 1);
                    }
                    ++index;
                }
            }
            gui.resetColor();
            for (Slot slot : ((ItemStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderInterfaceScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.iteminput.side", new Object[0]), 33, 57, 0x404040);
            int textWidth = gui.font.m_92852_((FormattedText)EasyText.translatable("gui.lightmanscurrency.settings.itemoutput.side", new Object[0]));
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.settings.itemoutput.side", new Object[0]), 173 - textWidth, 57, 0x404040);
        }
    }

    private String getCountText(ItemStack stack) {
        int count = stack.m_41613_();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + count % 1000 / 100;
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderItemStorage storage;
        int hoveredSlot;
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity && ((TraderInterfaceMenu)this.screen.m_6262_()).m_142621_().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * 8) < (storage = ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemBuffer()).getContents().size()) {
            ItemStack stack = storage.getContents().get(hoveredSlot);
            List<Component> tooltip = EasyScreenHelper.getTooltipFromItem(stack);
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage", stack.m_41613_()));
            if (stack.m_41613_() >= 64) {
                if (stack.m_41613_() % 64 == 0) {
                    tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage.stacks.single", stack.m_41613_() / 64));
                } else {
                    tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.itemstorage.stacks.multi", stack.m_41613_() / 64, stack.m_41613_() % 64));
                }
            }
            gui.renderComponentTooltip(tooltip);
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = this.screen.getGuiLeft() + 13;
        int topEdge = this.screen.getGuiTop() + 17;
        for (int x = 0; x < 8 && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 2 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * 8 + foundColumn;
    }

    private int totalStorageSlots() {
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity) {
            return ((ItemTraderInterfaceBlockEntity)this.menu.getBE()).getItemBuffer().getContents().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (this.menu.getBE() instanceof ItemTraderInterfaceBlockEntity && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((ItemStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * 8, Screen.m_96638_(), button == 0);
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / 8 - 2 + 1, 0);
    }

    private void ToggleInputSide(Direction side) {
        ((ItemStorageTab)this.commonTab).toggleInputSlot(side);
    }

    private void ToggleOutputSide(Direction side) {
        ((ItemStorageTab)this.commonTab).toggleOutputSlot(side);
    }
}

