/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class OwnershipClientTab
extends TraderInterfaceClientTab<OwnershipTab> {
    EditBox newOwnerInput;
    EasyButton buttonSetOwner;
    TeamSelectWidget teamSelection;
    EasyButton buttonSetTeamOwner;
    long selectedTeam = -1L;
    List<Team> teamList = new ArrayList<Team>();
    IconButton buttonToggleMode;
    boolean playerMode = true;

    public OwnershipClientTab(TraderInterfaceScreen screen, OwnershipTab tab) {
        super(screen, tab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.settings.owner", new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.newOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 23, screenArea.y + 26, 160, 20, (Component)EasyText.empty()));
        this.newOwnerInput.m_94199_(16);
        this.buttonSetOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(23, 47), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetOwner.f_93623_ = false;
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(13, 25), 4, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.buttonSetTeamOwner = this.addChild(new EasyTextButton(screenArea.pos.offset(23, 117), 160, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::setTeamOwner).withAddons(EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.buttonSetTeamOwner.f_93623_ = false;
        this.buttonToggleMode = this.addChild(new IconButton(screenArea.pos.offset(screenArea.width - 20 - 3, 3), this::toggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)this::getModeIcon)).withAddons(EasyAddonHelper.toggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)EasyText.translatable("tooltip.lightmanscurrency.settings.owner.player", new Object[0]), (Component)EasyText.translatable("tooltip.lightmanscurrency.settings.owner.team", new Object[0]))));
        this.tick();
    }

    private IconData getModeIcon() {
        return this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of((ItemLike)Items.f_42614_);
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = new ArrayList<Team>();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        if (this.menu.getBE() == null) {
            return;
        }
        gui.drawString(TextRenderUtil.fitString((Component)EasyText.translatable("gui.button.lightmanscurrency.team.owner", this.menu.getBE().getOwnerName()), this.screen.getXSize() - 20), 10, 10, 0x404040);
    }

    private void toggleMode(EasyButton button) {
        this.playerMode = !this.playerMode;
    }

    private void setOwner(EasyButton button) {
        if (this.newOwnerInput.m_94155_().isBlank()) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewOwner(this.newOwnerInput.m_94155_());
        this.newOwnerInput.m_94144_("");
    }

    private void setTeamOwner(EasyButton button) {
        if (this.selectedTeam < 0L) {
            return;
        }
        ((OwnershipTab)this.commonTab).setNewTeam(this.selectedTeam);
        this.selectedTeam = -1L;
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID() == this.selectedTeam ? -1L : newTeam.getID();
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.buttonSetOwner.f_93624_ = this.newOwnerInput.f_93624_ = this.playerMode;
        this.teamSelection.f_93624_ = !this.playerMode;
        this.buttonSetTeamOwner.f_93624_ = this.teamSelection.f_93624_;
        this.buttonSetOwner.f_93623_ = !this.newOwnerInput.m_94155_().isBlank();
        this.buttonSetTeamOwner.f_93623_ = this.getSelectedTeam() != null;
    }

    @Override
    public void closeAction() {
        this.selectedTeam = -1L;
        this.teamList = new ArrayList<Team>();
    }
}

