/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class OwnershipClientTab
extends TaxCollectorClientTab<OwnershipTab> {
    private boolean playerMode = true;
    private EditBox newOwnerInput;
    private long selectedTeam = -1L;
    private List<Team> teamList = new ArrayList<Team>();

    public OwnershipClientTab(Object screen, OwnershipTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42680_);
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.translatable("gui.lightmanscurrency.tax_collector.owner", new Object[0]);
    }

    private boolean isPlayerMode() {
        return this.playerMode;
    }

    private boolean isTeamMode() {
        return !this.playerMode;
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        if (firstOpen) {
            this.selectedTeam = -1L;
            this.playerMode = true;
        }
        this.newOwnerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 50, screenArea.width - 20, 20, (Component)EasyText.empty()));
        this.newOwnerInput.m_94199_(16);
        this.addChild(new EasyTextButton(screenArea.pos.offset(10, 72), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::SetOwnerPlayer).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::isPlayerMode)), EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.newOwnerInput != null && !this.newOwnerInput.m_94155_().isBlank())), EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 40), 5, TeamButton.Size.NORMAL, () -> this.teamList, this::getSelectedTeam, this::selectTeam).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::isTeamMode))));
        this.addChild(new EasyTextButton(screenArea.pos.offset(10, 145), screenArea.width - 20, 20, (Component)EasyText.translatable("gui.button.lightmanscurrency.set_owner", new Object[0]), this::SetOwnerTeam).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::isTeamMode)), EasyAddonHelper.activeCheck((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.getSelectedTeam() != null)), EasyAddonHelper.tooltip(IconAndButtonUtil.TOOLTIP_CANNOT_BE_UNDONE)));
        this.addChild(new IconButton(screenArea.pos.offset(screenArea.width - 25, 5), this::ToggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)this::GetModeIcon)).withAddons(EasyAddonHelper.toggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)this::isPlayerMode), (Component)EasyText.translatable("tooltip.lightmanscurrency.settings.owner.player", new Object[0]), (Component)EasyText.translatable("tooltip.lightmanscurrency.settings.owner.team", new Object[0]))));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TaxEntry entry = this.getEntry();
        String ownerName = "NULL";
        if (entry != null) {
            ownerName = entry.getOwner().getOwnerName();
        }
        gui.drawString((Component)EasyText.translatable("gui.button.lightmanscurrency.team.owner", ownerName), 8, 6, 0x404040);
    }

    @Override
    public void tick() {
        this.newOwnerInput.f_93624_ = this.isPlayerMode();
        this.recollectTeams();
    }

    private void ToggleMode(EasyButton button) {
        this.playerMode = !this.playerMode;
    }

    private IconData GetModeIcon() {
        return this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of((ItemLike)Items.f_42614_);
    }

    private void SetOwnerPlayer() {
        if (this.newOwnerInput != null) {
            ((OwnershipTab)this.commonTab).SetOwnerPlayer(this.newOwnerInput.m_94155_());
            this.newOwnerInput.m_94144_("");
        }
    }

    private void recollectTeams() {
        this.teamList = new ArrayList<Team>();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.menu.player)) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.menu.player));
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void selectTeam(int teamIndex) {
        if (teamIndex < 0 || teamIndex >= this.teamList.size()) {
            return;
        }
        Team team = this.teamList.get(teamIndex);
        if (team != null) {
            this.selectedTeam = team.getID();
        }
    }

    private void SetOwnerTeam() {
        if (this.selectedTeam < 0L) {
            return;
        }
        ((OwnershipTab)this.commonTab).SetOwnerTeam(this.selectedTeam);
    }

    @Override
    protected void closeAction() {
        this.selectedTeam = -1L;
        this.teamList = new ArrayList<Team>();
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.newOwnerInput.m_93696_();
    }
}

