/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.tax_collector;

import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.TaxCollectorClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.tax_collector.tabs.InfoTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.data.TaxStats;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class InfoClientTab
extends TaxCollectorClientTab<InfoTab> {
    public InfoClientTab(Object screen, InfoTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.translatable("gui.lightmanscurrency.tax_collector.info", new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        MutableComponent clearLabel = EasyText.translatable("gui.lightmanscurrency.tax_collector.stats.clear", new Object[0]);
        int buttonWidth = this.getFont().m_92852_((FormattedText)clearLabel) + 6;
        this.addChild(new EasyTextButton(screenArea.pos.offset(screenArea.width - buttonWidth - 8, 15), buttonWidth, 12, (Component)clearLabel, ((InfoTab)this.commonTab)::ClearInfoCache).withAddons(EasyAddonHelper.visibleCheck((NonNullSupplier<Boolean>)((NonNullSupplier)this::canClearStats))));
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString(this.getTooltip(), 8, 6, 0x404040);
        TaxEntry entry = this.getEntry();
        if (entry != null) {
            ITaxable taxable;
            TaxStats stats = entry.stats;
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.stats.total_collected", new Object[0]), 10, 35, 0x404040);
            gui.drawString(stats.getTotalCollected().getRandomValueText(), 10, 45, 0x404040);
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.stats.unique_taxables", stats.getUniqueTaxableCount()), 10, 65, 0x404040);
            TaxableReference mostTaxed = stats.getMostTaxed();
            gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.stats.most_taxed.label", new Object[0]), 10, 85, 0x404040);
            if (mostTaxed != null && (taxable = mostTaxed.getTaxable(true)) != null) {
                gui.drawString((Component)taxable.getName(), 10, 95, 0x404040);
                gui.drawString((Component)EasyText.translatable("gui.lightmanscurrency.tax_collector.stats.most_taxed.format", stats.getMostTaxedCount()), 10, 104, 0x404040);
            }
        }
    }

    private boolean canClearStats() {
        return ((InfoTab)this.commonTab).CanClearCache(this.getEntry());
    }
}

