/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class TransferTab
extends ATMTab {
    public static final int RESPONSE_DURATION = 100;
    private int responseTimer = 0;
    MoneyValueWidget amountWidget;
    EditBox playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    EasyButton buttonTransfer;
    long selectedTeam = -1L;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    public MutableComponent getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.atm.transfer", new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        this.responseTimer = 0;
        if (firstOpen) {
            ((ATMMenu)this.screen.m_6262_()).clearMessage();
        }
        this.amountWidget = this.addChild(new MoneyValueWidget(screenArea.pos, firstOpen ? null : this.amountWidget, MoneyValue.empty(), MoneyValueWidget.EMPTY_CONSUMER));
        this.amountWidget.allowFreeInput = false;
        this.amountWidget.drawBG = false;
        this.buttonToggleMode = this.addChild(new IconButton(screenArea.pos.offset(this.screen.f_96543_ - 30, 64), this::ToggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)() -> this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconAndButtonUtil.ICON_ALEX_HEAD)).withAddons(EasyAddonHelper.toggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)EasyText.translatable("tooltip.lightmanscurrency.atm.transfer.mode.team", new Object[0]), (Component)EasyText.translatable("tooltip.lightmanscurrency.atm.transfer.mode.player", new Object[0]))));
        this.playerInput = this.addChild(new EditBox(this.getFont(), screenArea.x + 10, screenArea.y + 104, screenArea.width - 20, 20, (Component)Component.m_237119_()));
        this.playerInput.f_93624_ = this.playerMode;
        this.teamSelection = this.addChild(new TeamSelectWidget(screenArea.pos.offset(10, 84), 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.f_93624_ = !this.playerMode;
        this.buttonTransfer = this.addChild(new EasyTextButton(screenArea.pos.offset(10, 126), screenArea.width - 20, 20, (NonNullSupplier<Component>)((NonNullSupplier)() -> EasyText.translatable(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team", new Object[0])), this::PressTransfer));
        this.buttonTransfer.f_93623_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankReference source = ((ATMMenu)this.screen.m_6262_()).getBankAccountReference();
        Team blockTeam = null;
        if (source instanceof TeamBankReference) {
            TeamBankReference teamBankReference = (TeamBankReference)source;
            blockTeam = TeamSaveData.GetTeam(true, teamBankReference.teamID);
        }
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam >= 0L) {
            return TeamSaveData.GetTeam(true, this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID() == this.selectedTeam) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void PressTransfer(EasyButton button) {
        if (this.playerMode) {
            new CPacketBankTransferPlayer(this.playerInput.m_94155_(), this.amountWidget.getCurrentValue()).send();
            this.playerInput.m_94144_("");
            this.amountWidget.changeValue(MoneyValue.empty());
        } else if (this.selectedTeam >= 0L) {
            new CPacketBankTransferTeam(this.selectedTeam, this.amountWidget.getCurrentValue()).send();
            this.amountWidget.changeValue(MoneyValue.empty());
        }
    }

    private void ToggleMode(EasyButton button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.m_93666_((Component)Component.m_237115_((String)(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team")));
        this.teamSelection.f_93624_ = !this.playerMode;
        this.playerInput.f_93624_ = this.playerMode;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.hideCoinSlots(gui);
        MutableComponent balance = ((ATMMenu)this.screen.m_6262_()).getBankAccount() == null ? EasyText.translatable("gui.lightmanscurrency.bank.null", new Object[0]) : EasyText.translatable("gui.lightmanscurrency.bank.balance", ((ATMMenu)this.screen.m_6262_()).getBankAccount().getMoneyStorage().getRandomValueText());
        gui.drawString((Component)balance, 8, 72, 0x404040);
        if (this.hasMessage()) {
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)this.getMessage(), 2, this.screen.getXSize() - 4, 5, 0x404040);
            this.amountWidget.f_93624_ = false;
        } else {
            this.amountWidget.f_93624_ = true;
        }
    }

    @Override
    public void tick() {
        if (this.playerMode) {
            this.buttonTransfer.f_93623_ = !this.playerInput.m_94155_().isBlank() && !this.amountWidget.getCurrentValue().isEmpty();
        } else {
            Team team = this.selectedTeam();
            boolean bl = this.buttonTransfer.f_93623_ = team != null && team.hasBankAccount() && !this.amountWidget.getCurrentValue().isEmpty();
        }
        if (this.hasMessage()) {
            ++this.responseTimer;
            if (this.responseTimer >= 100) {
                this.responseTimer = 0;
                ((ATMMenu)this.screen.m_6262_()).clearMessage();
            }
        }
    }

    private boolean hasMessage() {
        return ((ATMMenu)this.screen.m_6262_()).hasTransferMessage();
    }

    private MutableComponent getMessage() {
        return ((ATMMenu)this.screen.m_6262_()).getTransferMessage();
    }

    @Override
    public void closeAction() {
        SimpleSlot.SetActive(this.screen.m_6262_());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.m_6262_()).clearMessage();
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

