/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.client.util.ScreenCorner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class WalletDisplayOverlay
implements IGuiOverlay {
    public static final WalletDisplayOverlay INSTANCE = new WalletDisplayOverlay();
    private boolean sendError = true;

    private WalletDisplayOverlay() {
    }

    public void render(ForgeGui fgui, PoseStack pose, float partialTick, int screenWidth, int screenHeight) {
        block15: {
            if (!((Boolean)LCConfig.CLIENT.walletOverlayEnabled.get()).booleanValue()) {
                return;
            }
            try {
                IWalletHandler walletHandler;
                EasyGuiGraphics gui = EasyGuiGraphics.create(pose, fgui.m_93082_(), 0, 0, partialTick);
                ScreenCorner corner = (ScreenCorner)((Object)LCConfig.CLIENT.walletOverlayCorner.get());
                ScreenPosition offset = (ScreenPosition)LCConfig.CLIENT.walletOverlayPosition.get();
                ScreenPosition currentPosition = corner.getCorner(screenWidth, screenHeight).offset(offset);
                if (corner.isRightSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(-16, 0));
                }
                if (corner.isBottomSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(0, -16));
                }
                if ((walletHandler = WalletCapability.lazyGetWalletHandler((Entity)fgui.getMinecraft().f_91074_)) == null) {
                    return;
                }
                ItemStack wallet = walletHandler.getWallet();
                if (!WalletItem.isWallet(wallet)) break block15;
                gui.renderItem(wallet, currentPosition.x, currentPosition.y);
                currentPosition = corner.isRightSide ? currentPosition.offset(ScreenPosition.of(-17, 0)) : currentPosition.offset(ScreenPosition.of(17, 0));
                MoneyView contents = walletHandler.getStoredMoney();
                switch ((DisplayType)((Object)LCConfig.CLIENT.walletOverlayType.get())) {
                    case ITEMS_NARROW: 
                    case ITEMS_WIDE: {
                        List<Object> walletContents;
                        int offsetAmount = LCConfig.CLIENT.walletOverlayType.get() == DisplayType.ITEMS_WIDE ? 17 : 9;
                        MoneyValue randomValue = contents.getRandomValue();
                        if (randomValue instanceof CoinValue) {
                            CoinValue coinValue = (CoinValue)randomValue;
                            walletContents = coinValue.getAsItemList();
                        } else {
                            walletContents = new ArrayList();
                        }
                        for (ItemStack coin : walletContents) {
                            gui.renderItem(coin, currentPosition.x, currentPosition.y);
                            if (corner.isRightSide) {
                                currentPosition = currentPosition.offset(ScreenPosition.of(-offsetAmount, 0));
                                continue;
                            }
                            currentPosition = currentPosition.offset(ScreenPosition.of(offsetAmount, 0));
                        }
                        break;
                    }
                    case TEXT: {
                        MutableComponent walletText = contents.getRandomValueText();
                        if (corner.isRightSide) {
                            gui.drawString((Component)walletText, currentPosition.offset(-1 * gui.font.m_92852_((FormattedText)walletText), 3), 0xFFFFFF);
                            break;
                        }
                        gui.drawString((Component)walletText, currentPosition.offset(0, 3), 0xFFFFFF);
                    }
                }
            }
            catch (Throwable t) {
                if (!this.sendError) break block15;
                this.sendError = false;
                LightmansCurrency.LogError("Error occurred while rendering wallet overlay!", t);
            }
        }
    }

    public static enum DisplayType {
        ITEMS_WIDE,
        ITEMS_NARROW,
        TEXT;

    }
}

