/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.SyncedConfigFile;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ChestCoinCollectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.EjectionMenuButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.VisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet.WalletButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketOpenATM;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation WALLET_SLOT_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet_slot.png");
    public static final KeyMapping KEY_WALLET = new KeyMapping("key.wallet", 86, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_TERMINAL = new KeyMapping("key.portable_terminal", 92, "key.categories.inventory");
    public static final KeyMapping KEY_PORTABLE_ATM = new KeyMapping("key.portable_atm", 61, "key.categories.inventory");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof WalletScreen && minecraft.f_91074_ != null) {
            if (event.getAction() == 1 && event.getKey() == KEY_WALLET.getKey().m_84873_()) {
                minecraft.f_91074_.m_108763_();
            }
        } else if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            LocalPlayer player = minecraft.f_91074_;
            if (KEY_WALLET.m_90857_()) {
                new CPacketOpenWallet(-1).send();
                ItemStack wallet = CoinAPI.API.getEquippedWallet((Player)player);
                if (!wallet.m_41619_()) {
                    minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)(1.25f + player.f_19853_.f_46441_.m_188501_() * 0.5f), (float)0.75f));
                    if (!WalletItem.isEmpty(wallet)) {
                        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSounds.COINS_CLINKING.get()), (float)1.0f, (float)0.4f));
                    }
                }
            }
            if (LightmansCurrency.isCuriosLoaded() && event.getAction() == 1) {
                if (event.getKey() == KEY_PORTABLE_TERMINAL.getKey().m_84873_() && LCCurios.hasPortableTerminal((LivingEntity)minecraft.f_91074_)) {
                    new CPacketOpenNetworkTerminal(true).send();
                } else if (event.getKey() == KEY_PORTABLE_ATM.getKey().m_84873_() && LCCurios.hasPortableATM((LivingEntity)minecraft.f_91074_)) {
                    CPacketOpenATM.sendToServer();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            event.addListener((GuiEventListener)new NotificationButton(gui));
            event.addListener((GuiEventListener)new TeamManagerButton(gui));
            event.addListener((GuiEventListener)new EjectionMenuButton(gui));
            Minecraft mc = Minecraft.m_91087_();
            if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
                return;
            }
            event.addListener((GuiEventListener)new WalletButton(gui, b -> new CPacketOpenWallet(-1).send()));
            event.addListener((GuiEventListener)new VisibilityToggleButton(gui, ClientEvents::toggleVisibility));
        } else if (screen instanceof ContainerScreen) {
            ContainerScreen chestScreen = (ContainerScreen)screen;
            event.addListener((GuiEventListener)new ChestCoinCollectButton(chestScreen));
        }
    }

    private static void toggleVisibility(EasyButton button) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        IWalletHandler handler = WalletCapability.lazyGetWalletHandler((Entity)player);
        if (handler != null) {
            boolean nowVisible = !handler.visible();
            handler.setVisible(nowVisible);
            new CPacketSetVisible(player.m_19879_(), nowVisible).send();
        }
    }

    @SubscribeEvent
    public static void renderInventoryScreen(ContainerScreenEvent.Render.Background event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
            return;
        }
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            if (screen instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)screen).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ContainerScreenEvent.Render)event);
            ScreenPosition slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen).offsetScreen(screen);
            gui.resetColor();
            gui.blit(WALLET_SLOT_TEXTURE, slotPosition.x, slotPosition.y, 0, 0, 18, 18);
        }
    }

    @SubscribeEvent
    public static void renderInventoryTooltips(ScreenEvent.Render.Post event) {
        if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen screen = (AbstractContainerScreen)event.getScreen();
            if (!screen.m_6262_().m_142621_().m_41619_()) {
                return;
            }
            if (screen instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)screen).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            EasyGuiGraphics gui = EasyGuiGraphics.create((ScreenEvent.Render)event);
            NotificationButton.tryRenderTooltip(gui);
            TeamManagerButton.tryRenderTooltip(gui);
            EjectionMenuButton.tryRenderTooltip(gui);
        } else if (event.getScreen() instanceof ContainerScreen) {
            ChestCoinCollectButton.tryRenderTooltip(EasyGuiGraphics.create((ScreenEvent.Render)event), event.getMouseX(), event.getMouseY());
        }
    }

    public static ScreenPosition getWalletSlotPosition(boolean isCreative) {
        return isCreative ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
    }

    @SubscribeEvent
    public static void playerJoinsServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ConfigFile.loadClientFiles(ConfigFile.LoadPhase.GAME_START);
    }

    @SubscribeEvent
    public static void playerLeavesServer(ClientPlayerNetworkEvent.LoggingOut event) {
        SyncedConfigFile.onClientLeavesServer();
    }
}

