/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class UpgradeType {
    @Nonnull
    protected abstract List<String> getDataTags();

    @Nullable
    protected abstract Object defaultTagValue(String var1);

    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return new ArrayList<Component>();
    }

    @Nonnull
    public final UpgradeData getDefaultData() {
        return new UpgradeData(this);
    }

    public boolean clearDataFromStack(@Nonnull CompoundTag itemTag) {
        return false;
    }

    public static boolean hasUpgrade(@Nonnull UpgradeType type, @Nonnull Container upgradeContainer) {
        for (int i = 0; i < upgradeContainer.m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = upgradeContainer.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || (upgradeItem = (UpgradeItem)item).getUpgradeType() != type) continue;
            return true;
        }
        return false;
    }

    public static class Simple
    extends UpgradeType {
        private final List<Component> tooltips;

        public Simple(Component ... tooltips) {
            this.tooltips = ImmutableList.copyOf((Object[])tooltips);
        }

        @Override
        @Nonnull
        protected List<String> getDataTags() {
            return new ArrayList<String>();
        }

        @Override
        protected Object defaultTagValue(String tag) {
            return null;
        }

        @Override
        @Nonnull
        public List<Component> getTooltip(@Nonnull UpgradeData data) {
            return this.tooltips;
        }
    }
}

