/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UpgradeData {
    public static final UpgradeData EMPTY = new UpgradeData();
    private final Map<String, Object> data = new HashMap<String, Object>();

    public Set<String> getKeys() {
        return this.data.keySet();
    }

    public boolean hasKey(String tag) {
        return this.getKeys().contains(tag);
    }

    private UpgradeData() {
    }

    public UpgradeData(@Nonnull UpgradeType upgrade) {
        for (String tag : upgrade.getDataTags()) {
            Object defaultValue = upgrade.defaultTagValue(tag);
            this.data.put(tag, defaultValue);
        }
    }

    public void setValue(String tag, Object value) {
        if (this.data.containsKey(tag)) {
            this.data.put(tag, value);
        }
    }

    public Object getValue(String tag) {
        if (this.data.containsKey(tag)) {
            return this.data.get(tag);
        }
        return null;
    }

    public boolean getBooleanValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return b;
        }
        return false;
    }

    public int getIntValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        return 0;
    }

    public long getLongValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    public float getFloatValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof Float) {
            Float f = (Float)object;
            return f.floatValue();
        }
        return 0.0f;
    }

    public String getStringValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof String) {
            String s = (String)object;
            return s;
        }
        return "";
    }

    public CompoundTag getCompoundValue(String tag) {
        Object object = this.getValue(tag);
        if (object instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)object;
            return c;
        }
        return new CompoundTag();
    }

    public void read(CompoundTag compound) {
        compound.m_128431_().forEach(key -> {
            if (this.hasKey((String)key)) {
                if (compound.m_128425_(key, 1)) {
                    this.setValue((String)key, compound.m_128471_(key));
                } else if (compound.m_128425_(key, 3)) {
                    this.setValue((String)key, compound.m_128451_(key));
                } else if (compound.m_128425_(key, 4)) {
                    this.setValue((String)key, compound.m_128454_(key));
                } else if (compound.m_128425_(key, 5)) {
                    this.setValue((String)key, Float.valueOf(compound.m_128457_(key)));
                } else if (compound.m_128425_(key, 8)) {
                    this.setValue((String)key, compound.m_128461_(key));
                } else if (compound.m_128425_(key, 10)) {
                    this.setValue((String)key, compound.m_128469_(key));
                }
            }
        });
    }

    public CompoundTag writeToNBT() {
        return this.writeToNBT(null);
    }

    public CompoundTag writeToNBT(@Nullable UpgradeType source) {
        Map<String, Object> modifiedEntries = source == null ? this.data : UpgradeData.getModifiedEntries(this, source);
        CompoundTag compound = new CompoundTag();
        modifiedEntries.forEach((key, value) -> {
            if (value instanceof Boolean) {
                compound.m_128379_(key, ((Boolean)value).booleanValue());
            }
            if (value instanceof Integer) {
                compound.m_128405_(key, ((Integer)value).intValue());
            } else if (value instanceof Float) {
                compound.m_128350_(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                compound.m_128356_(key, ((Long)value).longValue());
            } else if (value instanceof String) {
                compound.m_128359_(key, (String)value);
            } else if (value instanceof CompoundTag) {
                compound.m_128365_(key, (Tag)((CompoundTag)value));
            }
        });
        return compound;
    }

    public static Map<String, Object> getModifiedEntries(UpgradeData queryData, UpgradeType source) {
        HashMap modifiedEntries = Maps.newHashMap();
        source.getDefaultData().data.forEach((key, value) -> {
            if (queryData.data.containsKey(key) && !Objects.equal((Object)queryData.data.get(key), (Object)value)) {
                modifiedEntries.put(key, value);
            }
        });
        return modifiedEntries;
    }
}

