/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade.client;

import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public abstract class TradeRenderManager<T extends TradeData> {
    public final T trade;

    protected TradeRenderManager(T trade) {
        this.trade = trade;
    }

    public abstract int tradeButtonWidth(TradeContext var1);

    public abstract LazyOptional<ScreenPosition> arrowPosition(TradeContext var1);

    public ScreenPosition alertPosition(TradeContext context) {
        return (ScreenPosition)this.arrowPosition(context).orElseGet(() -> ScreenPosition.ZERO);
    }

    public abstract DisplayData inputDisplayArea(TradeContext var1);

    public abstract List<DisplayEntry> getInputDisplays(TradeContext var1);

    public abstract DisplayData outputDisplayArea(TradeContext var1);

    public abstract List<DisplayEntry> getOutputDisplays(TradeContext var1);

    public final List<AlertData> getAlertData(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<AlertData> alerts = new ArrayList<AlertData>();
        this.addTradeRuleAlertData(alerts, context);
        if (context.getTrader().exceedsAcceptableTaxRate()) {
            alerts.add(AlertData.error(EasyText.translatable("tooltip.lightmanscurrency.tax_limit", new Object[0])));
        }
        this.getAdditionalAlertData(context, alerts);
        return alerts;
    }

    private void addTradeRuleAlertData(List<AlertData> alerts, TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            TradeEvent.PreTradeEvent pte = context.getTrader().runPreTradeEvent(context.getPlayerReference(), (TradeData)this.trade);
            alerts.addAll(pte.getAlertInfo());
        }
    }

    protected abstract void getAdditionalAlertData(TradeContext var1, List<AlertData> var2);

    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, TradeContext context) {
    }

    public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        return null;
    }
}

