/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.api.traders.trade.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class TradeData
implements ITradeRuleHost {
    public static final String DEFAULT_KEY = "Trades";
    protected MoneyValue cost = MoneyValue.empty();
    List<TradeRule> rules = new ArrayList<TradeRule>();
    private TradeCostCache cachedCost = TradeCostCache.EMPTY;
    private final boolean validateRules;

    public abstract TradeDirection getTradeDirection();

    public boolean validCost() {
        return this.getCost().isValidPrice();
    }

    public boolean isValid() {
        return this.validCost();
    }

    public MoneyValue getCost() {
        return this.cost;
    }

    protected void flagPriceAsChanged() {
        this.cachedCost = TradeCostCache.EMPTY;
    }

    public final MoneyValue getCost(@Nonnull TradeContext context) {
        if (!context.hasPlayerReference() || !context.hasTrader()) {
            return this.getCost();
        }
        TradeEvent.TradeCostEvent event = context.getTrader().runTradeCostEvent(context.getPlayerReference(), this);
        if (!this.cachedCost.matches(event)) {
            if (this.cachedCost != TradeCostCache.EMPTY) {
                LightmansCurrency.LogDebug("New price cached for a trade. Event results must have changed!");
            }
            this.cachedCost = TradeCostCache.cache(event);
        }
        return this.cachedCost.getPrice();
    }

    public MoneyValue getCostWithTaxes(TraderData trader) {
        MoneyValue cost = this.getCost();
        MoneyValue taxAmount = MoneyValue.empty();
        for (ITaxCollector entry : trader.getApplicableTaxes()) {
            taxAmount = taxAmount.addValue(cost.percentageOfValue(entry.getTaxRate()));
        }
        return cost.addValue(taxAmount);
    }

    public MoneyValue getCostWithTaxes(TradeContext context) {
        MoneyValue cost = this.getCost(context);
        if (context.hasTrader()) {
            TraderData trader = context.getTrader();
            MoneyValue taxAmount = MoneyValue.empty();
            for (ITaxCollector entry : trader.getApplicableTaxes()) {
                taxAmount = taxAmount.addValue(cost.percentageOfValue(entry.getTaxRate()));
            }
            return cost.addValue(taxAmount);
        }
        return cost;
    }

    public void setCost(MoneyValue value) {
        this.cost = value;
        this.flagPriceAsChanged();
    }

    public final int stockCountOfCost(TraderData trader) {
        if (this.getCost().isFree()) {
            return 1;
        }
        if (!this.getCost().isValidPrice()) {
            return 0;
        }
        MoneyValue storedMoney = trader.getStoredMoney().getStoredMoney().valueOf(this.getCost().getUniqueName());
        MoneyValue price = this.getCostWithTaxes(trader);
        return (int)(storedMoney.getCoreValue() / price.getCoreValue());
    }

    public final int stockCountOfCost(TradeContext context) {
        if (!context.hasTrader()) {
            return 0;
        }
        TraderData trader = context.getTrader();
        if (this.getCost().isFree()) {
            return 1;
        }
        if (!this.getCost().isValidPrice()) {
            return 0;
        }
        MoneyValue storedMoney = trader.getStoredMoney().getStoredMoney().valueOf(this.getCost().getUniqueName());
        MoneyValue price = this.getCostWithTaxes(context);
        return (int)MathUtil.SafeDivide(storedMoney.getCoreValue(), price.getCoreValue(), 1L);
    }

    protected TradeData(boolean validateRules) {
        this.validateRules = validateRules;
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = new CompoundTag();
        tradeNBT.m_128365_("Price", (Tag)this.cost.save());
        TradeRule.saveRules(tradeNBT, this.rules, "RuleData");
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundTag nbt) {
        this.cost = MoneyValue.safeLoad(nbt, "Price");
        this.flagPriceAsChanged();
        if (nbt.m_128441_("IsFree") && nbt.m_128471_("IsFree")) {
            this.cost = MoneyValue.free();
            this.flagPriceAsChanged();
        }
        this.rules.clear();
        if (nbt.m_128441_("TradeRules")) {
            this.rules = TradeRule.loadRules(nbt, "TradeRules", this);
            for (TradeRule r : this.rules) {
                r.setActive(true);
            }
        } else {
            this.rules = TradeRule.loadRules(nbt, "RuleData", this);
        }
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    @Override
    public final boolean isTrader() {
        return false;
    }

    @Override
    public final boolean isTrade() {
        return true;
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        return true;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
    }

    @Override
    @Nonnull
    public List<TradeRule> getRules() {
        return new ArrayList<TradeRule>(this.rules);
    }

    @Override
    public void markTradeRulesDirty() {
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public abstract List<Component> GetDifferenceWarnings(TradeComparisonResult var1);

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public abstract TradeRenderManager<?> getButtonRenderer();

    public abstract void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, @Nonnull ItemStack var5);

    public abstract void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, @Nonnull ItemStack var5);

    @Deprecated(since="2.1.2.4")
    public void onInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
    }

    public abstract void OnInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, int var5, @Nonnull ItemStack var6);

    @NotNull
    public final List<Integer> getRelevantInventorySlots(TradeContext context, List<Slot> slots) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.collectRelevantInventorySlots(context, slots, results);
        return results;
    }

    protected void collectRelevantInventorySlots(TradeContext context, List<Slot> slots, List<Integer> results) {
    }

    private static class TradeCostCache {
        private final boolean free;
        private final int percentage;
        private final MoneyValue price;
        public static final TradeCostCache EMPTY = new TradeCostCache(true, 0, MoneyValue.free());

        public MoneyValue getPrice() {
            return this.free ? MoneyValue.free() : this.price;
        }

        private TradeCostCache(boolean free, int percentage, MoneyValue price) {
            this.free = free;
            this.percentage = percentage;
            this.price = price;
        }

        public static TradeCostCache cache(@Nonnull TradeEvent.TradeCostEvent event) {
            return new TradeCostCache(event.getCostResultIsFree(), event.getPricePercentage(), event.getCostResult());
        }

        public boolean matches(@Nonnull TradeEvent.TradeCostEvent event) {
            if (event.getCostResultIsFree() && this.free) {
                return true;
            }
            return this.percentage == event.getPricePercentage();
        }
    }

    public static enum TradeDirection {
        SALE(0),
        PURCHASE(1),
        NONE(-1);

        public final int index;

        private TradeDirection(int index) {
            this.index = index;
        }

        public static TradeDirection fromIndex(int index) {
            for (TradeDirection d : TradeDirection.values()) {
                if (d.index != index) continue;
                return d;
            }
            return SALE;
        }
    }
}

