/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TraderBlockTallRotatable
extends TraderBlockRotatable
implements ITallBlock {
    protected static final BooleanProperty ISBOTTOM = BlockStateProperties.f_61427_;
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE_T);
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties);
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    @Override
    protected boolean shouldMakeTrader(BlockState state) {
        return this.getIsBottom(state);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity player, @NotNull ItemStack stack) {
        if (this.getReplacable(level, pos.m_7494_(), state, player, stack)) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        } else {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            if (player instanceof Player) {
                ItemStack giveStack = stack.m_41777_();
                giveStack.m_41764_(1);
                ((Player)player).m_150109_().m_36054_(giveStack);
            }
        }
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    public boolean getReplacable(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        if (player instanceof Player) {
            BlockPlaceContext context = new BlockPlaceContext(level, (Player)player, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, true));
            return level.m_8055_(pos).m_60629_(context);
        }
        return level.m_8055_(pos).m_60734_() == Blocks.f_50016_;
    }

    @Override
    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        TraderBlockEntity trader;
        this.playerWillDestroyBase(level, pos, state, player);
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity && !(trader = (TraderBlockEntity)blockEntity).canBreak(player)) {
            return;
        }
        this.setAir(level, this.getOtherHeight(pos, state), player);
    }

    @Override
    protected void onInvalidRemoval(BlockState state, Level level, BlockPos pos, TraderData trader) {
        super.onInvalidRemoval(state, level, pos, trader);
        this.setAir(level, this.getOtherHeight(pos, state), null);
    }

    protected final void setAir(Level level, BlockPos pos, Player player) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == this) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            if (player != null) {
                level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
            }
        }
    }

    @Override
    @Nonnull
    public BlockEntity getBlockEntity(@Nonnull BlockState state, @Nonnull LevelAccessor level, @Nonnull BlockPos pos) {
        if (level == null) {
            return null;
        }
        if (this.getIsTop(state)) {
            return level.m_7702_(pos.m_7495_());
        }
        return level.m_7702_(pos);
    }
}

